// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetCoreDeviceResponse private constructor(builder: Builder) {
    /**
     * The computer architecture of the core device.
     */
    public val architecture: kotlin.String? = builder.architecture
    /**
     * The name of the core device. This is also the name of the IoT thing.
     */
    public val coreDeviceThingName: kotlin.String? = builder.coreDeviceThingName
    /**
     * The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to the version of the Greengrass nucleus component that runs on the core device. For more information, see the [Greengrass nucleus component](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html) in the *IoT Greengrass V2 Developer Guide*.
     */
    public val coreVersion: kotlin.String? = builder.coreVersion
    /**
     * The time at which the core device's status last updated, expressed in ISO 8601 format.
     */
    public val lastStatusUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastStatusUpdateTimestamp
    /**
     * The operating system platform that the core device runs.
     */
    public val platform: kotlin.String? = builder.platform
    /**
     * The runtime for the core device. The runtime can be:
     * + `aws_nucleus_classic`
     * + `aws_nucleus_lite`
     */
    public val runtime: kotlin.String? = builder.runtime
    /**
     * The status of the core device. The core device status can be:
     * + `HEALTHY` – The IoT Greengrass Core software and all components run on the core device without issue.
     * + `UNHEALTHY` – The IoT Greengrass Core software or a component is in a failed state on the core device.
     */
    public val status: aws.sdk.kotlin.services.greengrassv2.model.CoreDeviceStatus? = builder.status
    /**
     * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.GetCoreDeviceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCoreDeviceResponse(")
        append("architecture=$architecture,")
        append("coreDeviceThingName=$coreDeviceThingName,")
        append("coreVersion=$coreVersion,")
        append("lastStatusUpdateTimestamp=$lastStatusUpdateTimestamp,")
        append("platform=$platform,")
        append("runtime=$runtime,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = architecture?.hashCode() ?: 0
        result = 31 * result + (coreDeviceThingName?.hashCode() ?: 0)
        result = 31 * result + (coreVersion?.hashCode() ?: 0)
        result = 31 * result + (lastStatusUpdateTimestamp?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (runtime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCoreDeviceResponse

        if (architecture != other.architecture) return false
        if (coreDeviceThingName != other.coreDeviceThingName) return false
        if (coreVersion != other.coreVersion) return false
        if (lastStatusUpdateTimestamp != other.lastStatusUpdateTimestamp) return false
        if (platform != other.platform) return false
        if (runtime != other.runtime) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.GetCoreDeviceResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The computer architecture of the core device.
         */
        public var architecture: kotlin.String? = null
        /**
         * The name of the core device. This is also the name of the IoT thing.
         */
        public var coreDeviceThingName: kotlin.String? = null
        /**
         * The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to the version of the Greengrass nucleus component that runs on the core device. For more information, see the [Greengrass nucleus component](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html) in the *IoT Greengrass V2 Developer Guide*.
         */
        public var coreVersion: kotlin.String? = null
        /**
         * The time at which the core device's status last updated, expressed in ISO 8601 format.
         */
        public var lastStatusUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The operating system platform that the core device runs.
         */
        public var platform: kotlin.String? = null
        /**
         * The runtime for the core device. The runtime can be:
         * + `aws_nucleus_classic`
         * + `aws_nucleus_lite`
         */
        public var runtime: kotlin.String? = null
        /**
         * The status of the core device. The core device status can be:
         * + `HEALTHY` – The IoT Greengrass Core software and all components run on the core device without issue.
         * + `UNHEALTHY` – The IoT Greengrass Core software or a component is in a failed state on the core device.
         */
        public var status: aws.sdk.kotlin.services.greengrassv2.model.CoreDeviceStatus? = null
        /**
         * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.GetCoreDeviceResponse) : this() {
            this.architecture = x.architecture
            this.coreDeviceThingName = x.coreDeviceThingName
            this.coreVersion = x.coreVersion
            this.lastStatusUpdateTimestamp = x.lastStatusUpdateTimestamp
            this.platform = x.platform
            this.runtime = x.runtime
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.GetCoreDeviceResponse = GetCoreDeviceResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
