// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.serde

import aws.sdk.kotlin.services.greengrassv2.model.ComponentDeploymentSpecification
import aws.sdk.kotlin.services.greengrassv2.model.CreateDeploymentRequest
import aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration
import aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDeploymentOperationSerializer: HttpSerializer.NonStreaming<CreateDeploymentRequest> {
    override fun serialize(context: ExecutionContext, input: CreateDeploymentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/greengrass/v2/deployments"
        }

        val payload = serializeCreateDeploymentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDeploymentOperationBody(context: ExecutionContext, input: CreateDeploymentRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val COMPONENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("components"))
    val DEPLOYMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentName"))
    val DEPLOYMENTPOLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deploymentPolicies"))
    val IOTJOBCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("iotJobConfiguration"))
    val PARENTTARGETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentTargetArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TARGETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(COMPONENTS_DESCRIPTOR)
        field(DEPLOYMENTNAME_DESCRIPTOR)
        field(DEPLOYMENTPOLICIES_DESCRIPTOR)
        field(IOTJOBCONFIGURATION_DESCRIPTOR)
        field(PARENTTARGETARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TARGETARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        if (input.components != null) {
            mapField(COMPONENTS_DESCRIPTOR) {
                input.components.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeComponentDeploymentSpecificationDocument)) }
            }
        }
        input.deploymentName?.let { field(DEPLOYMENTNAME_DESCRIPTOR, it) }
        input.deploymentPolicies?.let { field(DEPLOYMENTPOLICIES_DESCRIPTOR, it, ::serializeDeploymentPoliciesDocument) }
        input.iotJobConfiguration?.let { field(IOTJOBCONFIGURATION_DESCRIPTOR, it, ::serializeDeploymentIotJobConfigurationDocument) }
        input.parentTargetArn?.let { field(PARENTTARGETARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.targetArn?.let { field(TARGETARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
