// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about a component version that is compatible to run on a Greengrass core device.
 */
public class ResolvedComponentVersion private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the component version.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The name of the component.
     */
    public val componentName: kotlin.String? = builder.componentName
    /**
     * The version of the component.
     */
    public val componentVersion: kotlin.String? = builder.componentVersion
    /**
     * A message that communicates details about the vendor guidance state of the component version. This message communicates why a component version is discontinued or deleted.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The recipe of the component version.
     */
    public val recipe: kotlin.ByteArray? = builder.recipe
    /**
     * The vendor guidance state for the component version. This state indicates whether the component version has any issues that you should consider before you deploy it. The vendor guidance state can be:
     * + `ACTIVE` – This component version is available and recommended for use.
     * + `DISCONTINUED` – This component version has been discontinued by its publisher. You can deploy this component version, but we recommend that you use a different version of this component.
     * + `DELETED` – This component version has been deleted by its publisher, so you can't deploy it. If you have any existing deployments that specify this component version, those deployments will fail.
     */
    public val vendorGuidance: aws.sdk.kotlin.services.greengrassv2.model.VendorGuidance? = builder.vendorGuidance

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.ResolvedComponentVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResolvedComponentVersion(")
        append("arn=$arn,")
        append("componentName=$componentName,")
        append("componentVersion=$componentVersion,")
        append("message=$message,")
        append("recipe=$recipe,")
        append("vendorGuidance=$vendorGuidance")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (recipe?.contentHashCode() ?: 0)
        result = 31 * result + (vendorGuidance?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResolvedComponentVersion

        if (arn != other.arn) return false
        if (componentName != other.componentName) return false
        if (componentVersion != other.componentVersion) return false
        if (message != other.message) return false
        if (recipe != null) {
            if (other.recipe == null) return false
            if (!recipe.contentEquals(other.recipe)) return false
        } else if (other.recipe != null) return false
        if (vendorGuidance != other.vendorGuidance) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.ResolvedComponentVersion = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the component version.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the component.
         */
        public var componentName: kotlin.String? = null
        /**
         * The version of the component.
         */
        public var componentVersion: kotlin.String? = null
        /**
         * A message that communicates details about the vendor guidance state of the component version. This message communicates why a component version is discontinued or deleted.
         */
        public var message: kotlin.String? = null
        /**
         * The recipe of the component version.
         */
        public var recipe: kotlin.ByteArray? = null
        /**
         * The vendor guidance state for the component version. This state indicates whether the component version has any issues that you should consider before you deploy it. The vendor guidance state can be:
         * + `ACTIVE` – This component version is available and recommended for use.
         * + `DISCONTINUED` – This component version has been discontinued by its publisher. You can deploy this component version, but we recommend that you use a different version of this component.
         * + `DELETED` – This component version has been deleted by its publisher, so you can't deploy it. If you have any existing deployments that specify this component version, those deployments will fail.
         */
        public var vendorGuidance: aws.sdk.kotlin.services.greengrassv2.model.VendorGuidance? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.ResolvedComponentVersion) : this() {
            this.arn = x.arn
            this.componentName = x.componentName
            this.componentVersion = x.componentVersion
            this.message = x.message
            this.recipe = x.recipe
            this.vendorGuidance = x.vendorGuidance
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.ResolvedComponentVersion = ResolvedComponentVersion(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
