// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about an Lambda function to import to create a component.
 */
public class LambdaFunctionRecipeSource private constructor(builder: Builder) {
    /**
     * The component versions on which this Lambda function component depends.
     */
    public val componentDependencies: Map<String, ComponentDependencyRequirement>? = builder.componentDependencies
    /**
     * The system and runtime parameters for the Lambda function as it runs on the Greengrass core device.
     */
    public val componentLambdaParameters: aws.sdk.kotlin.services.greengrassv2.model.LambdaExecutionParameters? = builder.componentLambdaParameters
    /**
     * The name of the component.
     *
     * Defaults to the name of the Lambda function.
     */
    public val componentName: kotlin.String? = builder.componentName
    /**
     * The platforms that the component version supports.
     */
    public val componentPlatforms: List<ComponentPlatform>? = builder.componentPlatforms
    /**
     * The version of the component.
     *
     * Defaults to the version of the Lambda function as a semantic version. For example, if your function version is `3`, the component version becomes `3.0.0`.
     */
    public val componentVersion: kotlin.String? = builder.componentVersion
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Lambda function. The ARN must include the version of the function to import. You can't use version aliases like `$LATEST`.
     */
    public val lambdaArn: kotlin.String = requireNotNull(builder.lambdaArn) { "A non-null value must be provided for lambdaArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.LambdaFunctionRecipeSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionRecipeSource(")
        append("componentDependencies=$componentDependencies,")
        append("componentLambdaParameters=$componentLambdaParameters,")
        append("componentName=$componentName,")
        append("componentPlatforms=$componentPlatforms,")
        append("componentVersion=$componentVersion,")
        append("lambdaArn=$lambdaArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentDependencies?.hashCode() ?: 0
        result = 31 * result + (componentLambdaParameters?.hashCode() ?: 0)
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (componentPlatforms?.hashCode() ?: 0)
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (lambdaArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaFunctionRecipeSource

        if (componentDependencies != other.componentDependencies) return false
        if (componentLambdaParameters != other.componentLambdaParameters) return false
        if (componentName != other.componentName) return false
        if (componentPlatforms != other.componentPlatforms) return false
        if (componentVersion != other.componentVersion) return false
        if (lambdaArn != other.lambdaArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.LambdaFunctionRecipeSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The component versions on which this Lambda function component depends.
         */
        public var componentDependencies: Map<String, ComponentDependencyRequirement>? = null
        /**
         * The system and runtime parameters for the Lambda function as it runs on the Greengrass core device.
         */
        public var componentLambdaParameters: aws.sdk.kotlin.services.greengrassv2.model.LambdaExecutionParameters? = null
        /**
         * The name of the component.
         *
         * Defaults to the name of the Lambda function.
         */
        public var componentName: kotlin.String? = null
        /**
         * The platforms that the component version supports.
         */
        public var componentPlatforms: List<ComponentPlatform>? = null
        /**
         * The version of the component.
         *
         * Defaults to the version of the Lambda function as a semantic version. For example, if your function version is `3`, the component version becomes `3.0.0`.
         */
        public var componentVersion: kotlin.String? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Lambda function. The ARN must include the version of the function to import. You can't use version aliases like `$LATEST`.
         */
        public var lambdaArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.LambdaFunctionRecipeSource) : this() {
            this.componentDependencies = x.componentDependencies
            this.componentLambdaParameters = x.componentLambdaParameters
            this.componentName = x.componentName
            this.componentPlatforms = x.componentPlatforms
            this.componentVersion = x.componentVersion
            this.lambdaArn = x.lambdaArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.LambdaFunctionRecipeSource = LambdaFunctionRecipeSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.LambdaExecutionParameters] inside the given [block]
         */
        public fun componentLambdaParameters(block: aws.sdk.kotlin.services.greengrassv2.model.LambdaExecutionParameters.Builder.() -> kotlin.Unit) {
            this.componentLambdaParameters = aws.sdk.kotlin.services.greengrassv2.model.LambdaExecutionParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (lambdaArn == null) lambdaArn = ""
            return this
        }
    }
}
