// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains parameters for a Lambda function that runs on IoT Greengrass.
 */
public class LambdaExecutionParameters private constructor(builder: Builder) {
    /**
     * The map of environment variables that are available to the Lambda function when it runs.
     */
    public val environmentVariables: Map<String, String>? = builder.environmentVariables
    /**
     * The list of event sources to which to subscribe to receive work messages. The Lambda function runs when it receives a message from an event source. You can subscribe this function to local publish/subscribe messages and Amazon Web Services IoT Core MQTT messages.
     */
    public val eventSources: List<LambdaEventSource>? = builder.eventSources
    /**
     * The list of arguments to pass to the Lambda function when it runs.
     */
    public val execArgs: List<String>? = builder.execArgs
    /**
     * The encoding type that the Lambda function supports.
     *
     * Default: `json`
     */
    public val inputPayloadEncodingType: aws.sdk.kotlin.services.greengrassv2.model.LambdaInputPayloadEncodingType? = builder.inputPayloadEncodingType
    /**
     * The parameters for the Linux process that contains the Lambda function.
     */
    public val linuxProcessParams: aws.sdk.kotlin.services.greengrassv2.model.LambdaLinuxProcessParams? = builder.linuxProcessParams
    /**
     * The maximum amount of time in seconds that a non-pinned Lambda function can idle before the IoT Greengrass Core software stops its process.
     */
    public val maxIdleTimeInSeconds: kotlin.Int? = builder.maxIdleTimeInSeconds
    /**
     * The maximum number of instances that a non-pinned Lambda function can run at the same time.
     */
    public val maxInstancesCount: kotlin.Int? = builder.maxInstancesCount
    /**
     * The maximum size of the message queue for the Lambda function component. The IoT Greengrass core stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to consume each message.
     */
    public val maxQueueSize: kotlin.Int? = builder.maxQueueSize
    /**
     * Whether or not the Lambda function is pinned, or long-lived.
     * + A pinned Lambda function starts when IoT Greengrass starts and keeps running in its own container.
     * + A non-pinned Lambda function starts only when it receives a work item and exists after it idles for `maxIdleTimeInSeconds`. If the function has multiple work items, the IoT Greengrass Core software creates multiple instances of the function.
     *
     * Default: `true`
     */
    public val pinned: kotlin.Boolean? = builder.pinned
    /**
     * The interval in seconds at which a pinned (also known as long-lived) Lambda function component sends status updates to the Lambda manager component.
     */
    public val statusTimeoutInSeconds: kotlin.Int? = builder.statusTimeoutInSeconds
    /**
     * The maximum amount of time in seconds that the Lambda function can process a work item.
     */
    public val timeoutInSeconds: kotlin.Int? = builder.timeoutInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.LambdaExecutionParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaExecutionParameters(")
        append("environmentVariables=$environmentVariables,")
        append("eventSources=$eventSources,")
        append("execArgs=$execArgs,")
        append("inputPayloadEncodingType=$inputPayloadEncodingType,")
        append("linuxProcessParams=$linuxProcessParams,")
        append("maxIdleTimeInSeconds=$maxIdleTimeInSeconds,")
        append("maxInstancesCount=$maxInstancesCount,")
        append("maxQueueSize=$maxQueueSize,")
        append("pinned=$pinned,")
        append("statusTimeoutInSeconds=$statusTimeoutInSeconds,")
        append("timeoutInSeconds=$timeoutInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = environmentVariables?.hashCode() ?: 0
        result = 31 * result + (eventSources?.hashCode() ?: 0)
        result = 31 * result + (execArgs?.hashCode() ?: 0)
        result = 31 * result + (inputPayloadEncodingType?.hashCode() ?: 0)
        result = 31 * result + (linuxProcessParams?.hashCode() ?: 0)
        result = 31 * result + (maxIdleTimeInSeconds ?: 0)
        result = 31 * result + (maxInstancesCount ?: 0)
        result = 31 * result + (maxQueueSize ?: 0)
        result = 31 * result + (pinned?.hashCode() ?: 0)
        result = 31 * result + (statusTimeoutInSeconds ?: 0)
        result = 31 * result + (timeoutInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaExecutionParameters

        if (environmentVariables != other.environmentVariables) return false
        if (eventSources != other.eventSources) return false
        if (execArgs != other.execArgs) return false
        if (inputPayloadEncodingType != other.inputPayloadEncodingType) return false
        if (linuxProcessParams != other.linuxProcessParams) return false
        if (maxIdleTimeInSeconds != other.maxIdleTimeInSeconds) return false
        if (maxInstancesCount != other.maxInstancesCount) return false
        if (maxQueueSize != other.maxQueueSize) return false
        if (pinned != other.pinned) return false
        if (statusTimeoutInSeconds != other.statusTimeoutInSeconds) return false
        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.LambdaExecutionParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The map of environment variables that are available to the Lambda function when it runs.
         */
        public var environmentVariables: Map<String, String>? = null
        /**
         * The list of event sources to which to subscribe to receive work messages. The Lambda function runs when it receives a message from an event source. You can subscribe this function to local publish/subscribe messages and Amazon Web Services IoT Core MQTT messages.
         */
        public var eventSources: List<LambdaEventSource>? = null
        /**
         * The list of arguments to pass to the Lambda function when it runs.
         */
        public var execArgs: List<String>? = null
        /**
         * The encoding type that the Lambda function supports.
         *
         * Default: `json`
         */
        public var inputPayloadEncodingType: aws.sdk.kotlin.services.greengrassv2.model.LambdaInputPayloadEncodingType? = null
        /**
         * The parameters for the Linux process that contains the Lambda function.
         */
        public var linuxProcessParams: aws.sdk.kotlin.services.greengrassv2.model.LambdaLinuxProcessParams? = null
        /**
         * The maximum amount of time in seconds that a non-pinned Lambda function can idle before the IoT Greengrass Core software stops its process.
         */
        public var maxIdleTimeInSeconds: kotlin.Int? = null
        /**
         * The maximum number of instances that a non-pinned Lambda function can run at the same time.
         */
        public var maxInstancesCount: kotlin.Int? = null
        /**
         * The maximum size of the message queue for the Lambda function component. The IoT Greengrass core stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to consume each message.
         */
        public var maxQueueSize: kotlin.Int? = null
        /**
         * Whether or not the Lambda function is pinned, or long-lived.
         * + A pinned Lambda function starts when IoT Greengrass starts and keeps running in its own container.
         * + A non-pinned Lambda function starts only when it receives a work item and exists after it idles for `maxIdleTimeInSeconds`. If the function has multiple work items, the IoT Greengrass Core software creates multiple instances of the function.
         *
         * Default: `true`
         */
        public var pinned: kotlin.Boolean? = null
        /**
         * The interval in seconds at which a pinned (also known as long-lived) Lambda function component sends status updates to the Lambda manager component.
         */
        public var statusTimeoutInSeconds: kotlin.Int? = null
        /**
         * The maximum amount of time in seconds that the Lambda function can process a work item.
         */
        public var timeoutInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.LambdaExecutionParameters) : this() {
            this.environmentVariables = x.environmentVariables
            this.eventSources = x.eventSources
            this.execArgs = x.execArgs
            this.inputPayloadEncodingType = x.inputPayloadEncodingType
            this.linuxProcessParams = x.linuxProcessParams
            this.maxIdleTimeInSeconds = x.maxIdleTimeInSeconds
            this.maxInstancesCount = x.maxInstancesCount
            this.maxQueueSize = x.maxQueueSize
            this.pinned = x.pinned
            this.statusTimeoutInSeconds = x.statusTimeoutInSeconds
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.LambdaExecutionParameters = LambdaExecutionParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.LambdaLinuxProcessParams] inside the given [block]
         */
        public fun linuxProcessParams(block: aws.sdk.kotlin.services.greengrassv2.model.LambdaLinuxProcessParams.Builder.() -> kotlin.Unit) {
            this.linuxProcessParams = aws.sdk.kotlin.services.greengrassv2.model.LambdaLinuxProcessParams.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
