// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about an event source for an Lambda function. The event source defines the topics on which this Lambda function subscribes to receive messages that run the function.
 */
public class LambdaEventSource private constructor(builder: Builder) {
    /**
     * The topic to which to subscribe to receive event messages.
     */
    public val topic: kotlin.String = requireNotNull(builder.topic) { "A non-null value must be provided for topic" }
    /**
     * The type of event source. Choose from the following options:
     * + `PUB_SUB` – Subscribe to local publish/subscribe messages. This event source type doesn't support MQTT wildcards (`+` and `#`) in the event source topic.
     * + `IOT_CORE` – Subscribe to Amazon Web Services IoT Core MQTT messages. This event source type supports MQTT wildcards (`+` and `#`) in the event source topic.
     */
    public val type: aws.sdk.kotlin.services.greengrassv2.model.LambdaEventSourceType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.LambdaEventSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaEventSource(")
        append("topic=$topic,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = topic.hashCode()
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaEventSource

        if (topic != other.topic) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.LambdaEventSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The topic to which to subscribe to receive event messages.
         */
        public var topic: kotlin.String? = null
        /**
         * The type of event source. Choose from the following options:
         * + `PUB_SUB` – Subscribe to local publish/subscribe messages. This event source type doesn't support MQTT wildcards (`+` and `#`) in the event source topic.
         * + `IOT_CORE` – Subscribe to Amazon Web Services IoT Core MQTT messages. This event source type supports MQTT wildcards (`+` and `#`) in the event source topic.
         */
        public var type: aws.sdk.kotlin.services.greengrassv2.model.LambdaEventSourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.LambdaEventSource) : this() {
            this.topic = x.topic
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.LambdaEventSource = LambdaEventSource(this)

        internal fun correctErrors(): Builder {
            if (topic == null) topic = ""
            if (type == null) type = LambdaEventSourceType.SdkUnknown("no value provided")
            return this
        }
    }
}
