// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains criteria that define when and how to cancel a job.
 *
 * The deployment stops if the following conditions are true:
 * + The number of things that receive the deployment exceeds the `minNumberOfExecutedThings`.
 * + The percentage of failures with type `failureType` exceeds the `thresholdPercentage`.
 */
public class IotJobAbortCriteria private constructor(builder: Builder) {
    /**
     * The action to perform when the criteria are met.
     */
    public val action: aws.sdk.kotlin.services.greengrassv2.model.IotJobAbortAction = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * The type of job deployment failure that can cancel a job.
     */
    public val failureType: aws.sdk.kotlin.services.greengrassv2.model.IotJobExecutionFailureType = requireNotNull(builder.failureType) { "A non-null value must be provided for failureType" }
    /**
     * The minimum number of things that receive the configuration before the job can cancel.
     */
    public val minNumberOfExecutedThings: kotlin.Int = requireNotNull(builder.minNumberOfExecutedThings) { "A non-null value must be provided for minNumberOfExecutedThings" }
    /**
     * The minimum percentage of `failureType` failures that occur before the job can cancel.
     *
     * This parameter supports up to two digits after the decimal (for example, you can specify `10.9` or `10.99`, but not `10.999`).
     */
    public val thresholdPercentage: kotlin.Double = builder.thresholdPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.IotJobAbortCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IotJobAbortCriteria(")
        append("action=$action,")
        append("failureType=$failureType,")
        append("minNumberOfExecutedThings=$minNumberOfExecutedThings,")
        append("thresholdPercentage=$thresholdPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (failureType.hashCode())
        result = 31 * result + (minNumberOfExecutedThings)
        result = 31 * result + (thresholdPercentage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IotJobAbortCriteria

        if (action != other.action) return false
        if (failureType != other.failureType) return false
        if (minNumberOfExecutedThings != other.minNumberOfExecutedThings) return false
        if (!(thresholdPercentage?.equals(other.thresholdPercentage) ?: (other.thresholdPercentage == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.IotJobAbortCriteria = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action to perform when the criteria are met.
         */
        public var action: aws.sdk.kotlin.services.greengrassv2.model.IotJobAbortAction? = null
        /**
         * The type of job deployment failure that can cancel a job.
         */
        public var failureType: aws.sdk.kotlin.services.greengrassv2.model.IotJobExecutionFailureType? = null
        /**
         * The minimum number of things that receive the configuration before the job can cancel.
         */
        public var minNumberOfExecutedThings: kotlin.Int? = null
        /**
         * The minimum percentage of `failureType` failures that occur before the job can cancel.
         *
         * This parameter supports up to two digits after the decimal (for example, you can specify `10.9` or `10.99`, but not `10.999`).
         */
        public var thresholdPercentage: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.IotJobAbortCriteria) : this() {
            this.action = x.action
            this.failureType = x.failureType
            this.minNumberOfExecutedThings = x.minNumberOfExecutedThings
            this.thresholdPercentage = x.thresholdPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.IotJobAbortCriteria = IotJobAbortCriteria(this)

        internal fun correctErrors(): Builder {
            if (action == null) action = IotJobAbortAction.SdkUnknown("no value provided")
            if (failureType == null) failureType = IotJobExecutionFailureType.SdkUnknown("no value provided")
            if (minNumberOfExecutedThings == null) minNumberOfExecutedThings = 0
            return this
        }
    }
}
