// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetDeploymentResponse private constructor(builder: Builder) {
    /**
     * The components to deploy. This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.
     */
    public val components: Map<String, ComponentDeploymentSpecification>? = builder.components
    /**
     * The time at which the deployment was created, expressed in ISO 8601 format.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The ID of the deployment.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The name of the deployment.
     */
    public val deploymentName: kotlin.String? = builder.deploymentName
    /**
     * The deployment policies for the deployment. These policies define how the deployment updates components and handles failure.
     */
    public val deploymentPolicies: aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies? = builder.deploymentPolicies
    /**
     * The status of the deployment.
     */
    public val deploymentStatus: aws.sdk.kotlin.services.greengrassv2.model.DeploymentStatus? = builder.deploymentStatus
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IoT job that applies the deployment to target devices.
     */
    public val iotJobArn: kotlin.String? = builder.iotJobArn
    /**
     * The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.
     */
    public val iotJobConfiguration: aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration? = builder.iotJobConfiguration
    /**
     * The ID of the IoT job that applies the deployment to target devices.
     */
    public val iotJobId: kotlin.String? = builder.iotJobId
    /**
     * Whether or not the deployment is the latest revision for its target.
     */
    public val isLatestForTarget: kotlin.Boolean = builder.isLatestForTarget
    /**
     * The parent deployment's target [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) within a subdeployment.
     */
    public val parentTargetArn: kotlin.String? = builder.parentTargetArn
    /**
     * The revision number of the deployment.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the target IoT thing or thing group.
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.GetDeploymentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDeploymentResponse(")
        append("components=$components,")
        append("creationTimestamp=$creationTimestamp,")
        append("deploymentId=$deploymentId,")
        append("deploymentName=$deploymentName,")
        append("deploymentPolicies=$deploymentPolicies,")
        append("deploymentStatus=$deploymentStatus,")
        append("iotJobArn=$iotJobArn,")
        append("iotJobConfiguration=$iotJobConfiguration,")
        append("iotJobId=$iotJobId,")
        append("isLatestForTarget=$isLatestForTarget,")
        append("parentTargetArn=$parentTargetArn,")
        append("revisionId=$revisionId,")
        append("tags=$tags,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = components?.hashCode() ?: 0
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (deploymentName?.hashCode() ?: 0)
        result = 31 * result + (deploymentPolicies?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (iotJobArn?.hashCode() ?: 0)
        result = 31 * result + (iotJobConfiguration?.hashCode() ?: 0)
        result = 31 * result + (iotJobId?.hashCode() ?: 0)
        result = 31 * result + (isLatestForTarget.hashCode())
        result = 31 * result + (parentTargetArn?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDeploymentResponse

        if (components != other.components) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (deploymentId != other.deploymentId) return false
        if (deploymentName != other.deploymentName) return false
        if (deploymentPolicies != other.deploymentPolicies) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (iotJobArn != other.iotJobArn) return false
        if (iotJobConfiguration != other.iotJobConfiguration) return false
        if (iotJobId != other.iotJobId) return false
        if (isLatestForTarget != other.isLatestForTarget) return false
        if (parentTargetArn != other.parentTargetArn) return false
        if (revisionId != other.revisionId) return false
        if (tags != other.tags) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.GetDeploymentResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The components to deploy. This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.
         */
        public var components: Map<String, ComponentDeploymentSpecification>? = null
        /**
         * The time at which the deployment was created, expressed in ISO 8601 format.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the deployment.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * The name of the deployment.
         */
        public var deploymentName: kotlin.String? = null
        /**
         * The deployment policies for the deployment. These policies define how the deployment updates components and handles failure.
         */
        public var deploymentPolicies: aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies? = null
        /**
         * The status of the deployment.
         */
        public var deploymentStatus: aws.sdk.kotlin.services.greengrassv2.model.DeploymentStatus? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IoT job that applies the deployment to target devices.
         */
        public var iotJobArn: kotlin.String? = null
        /**
         * The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.
         */
        public var iotJobConfiguration: aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration? = null
        /**
         * The ID of the IoT job that applies the deployment to target devices.
         */
        public var iotJobId: kotlin.String? = null
        /**
         * Whether or not the deployment is the latest revision for its target.
         */
        public var isLatestForTarget: kotlin.Boolean = false
        /**
         * The parent deployment's target [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) within a subdeployment.
         */
        public var parentTargetArn: kotlin.String? = null
        /**
         * The revision number of the deployment.
         */
        public var revisionId: kotlin.String? = null
        /**
         * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
         */
        public var tags: Map<String, String>? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the target IoT thing or thing group.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.GetDeploymentResponse) : this() {
            this.components = x.components
            this.creationTimestamp = x.creationTimestamp
            this.deploymentId = x.deploymentId
            this.deploymentName = x.deploymentName
            this.deploymentPolicies = x.deploymentPolicies
            this.deploymentStatus = x.deploymentStatus
            this.iotJobArn = x.iotJobArn
            this.iotJobConfiguration = x.iotJobConfiguration
            this.iotJobId = x.iotJobId
            this.isLatestForTarget = x.isLatestForTarget
            this.parentTargetArn = x.parentTargetArn
            this.revisionId = x.revisionId
            this.tags = x.tags
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.GetDeploymentResponse = GetDeploymentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies] inside the given [block]
         */
        public fun deploymentPolicies(block: aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies.Builder.() -> kotlin.Unit) {
            this.deploymentPolicies = aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration] inside the given [block]
         */
        public fun iotJobConfiguration(block: aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration.Builder.() -> kotlin.Unit) {
            this.iotJobConfiguration = aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
