// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a deployment.
 */
public class Deployment private constructor(builder: Builder) {
    /**
     * The time at which the deployment was created, expressed in ISO 8601 format.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The ID of the deployment.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The name of the deployment.
     */
    public val deploymentName: kotlin.String? = builder.deploymentName
    /**
     * The status of the deployment.
     */
    public val deploymentStatus: aws.sdk.kotlin.services.greengrassv2.model.DeploymentStatus? = builder.deploymentStatus
    /**
     * Whether or not the deployment is the latest revision for its target.
     */
    public val isLatestForTarget: kotlin.Boolean = builder.isLatestForTarget
    /**
     * The parent deployment's target [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) within a subdeployment.
     */
    public val parentTargetArn: kotlin.String? = builder.parentTargetArn
    /**
     * The revision number of the deployment.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the target IoT thing or thing group. When creating a subdeployment, the targetARN can only be a thing group.
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.Deployment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Deployment(")
        append("creationTimestamp=$creationTimestamp,")
        append("deploymentId=$deploymentId,")
        append("deploymentName=$deploymentName,")
        append("deploymentStatus=$deploymentStatus,")
        append("isLatestForTarget=$isLatestForTarget,")
        append("parentTargetArn=$parentTargetArn,")
        append("revisionId=$revisionId,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (deploymentName?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (isLatestForTarget.hashCode())
        result = 31 * result + (parentTargetArn?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Deployment

        if (creationTimestamp != other.creationTimestamp) return false
        if (deploymentId != other.deploymentId) return false
        if (deploymentName != other.deploymentName) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (isLatestForTarget != other.isLatestForTarget) return false
        if (parentTargetArn != other.parentTargetArn) return false
        if (revisionId != other.revisionId) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.Deployment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time at which the deployment was created, expressed in ISO 8601 format.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the deployment.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * The name of the deployment.
         */
        public var deploymentName: kotlin.String? = null
        /**
         * The status of the deployment.
         */
        public var deploymentStatus: aws.sdk.kotlin.services.greengrassv2.model.DeploymentStatus? = null
        /**
         * Whether or not the deployment is the latest revision for its target.
         */
        public var isLatestForTarget: kotlin.Boolean = false
        /**
         * The parent deployment's target [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) within a subdeployment.
         */
        public var parentTargetArn: kotlin.String? = null
        /**
         * The revision number of the deployment.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the target IoT thing or thing group. When creating a subdeployment, the targetARN can only be a thing group.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.Deployment) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.deploymentId = x.deploymentId
            this.deploymentName = x.deploymentName
            this.deploymentStatus = x.deploymentStatus
            this.isLatestForTarget = x.isLatestForTarget
            this.parentTargetArn = x.parentTargetArn
            this.revisionId = x.revisionId
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.Deployment = Deployment(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
