// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateComponentVersionResponse private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the component version.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The name of the component.
     */
    public val componentName: kotlin.String = requireNotNull(builder.componentName) { "A non-null value must be provided for componentName" }
    /**
     * The version of the component.
     */
    public val componentVersion: kotlin.String = requireNotNull(builder.componentVersion) { "A non-null value must be provided for componentVersion" }
    /**
     * The time at which the component was created, expressed in ISO 8601 format.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTimestamp) { "A non-null value must be provided for creationTimestamp" }
    /**
     * The status of the component version in IoT Greengrass V2. This status is different from the status of the component on a core device.
     */
    public val status: aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.CreateComponentVersionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateComponentVersionResponse(")
        append("arn=$arn,")
        append("componentName=$componentName,")
        append("componentVersion=$componentVersion,")
        append("creationTimestamp=$creationTimestamp,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (componentName.hashCode())
        result = 31 * result + (componentVersion.hashCode())
        result = 31 * result + (creationTimestamp.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateComponentVersionResponse

        if (arn != other.arn) return false
        if (componentName != other.componentName) return false
        if (componentVersion != other.componentVersion) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.CreateComponentVersionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the component version.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the component.
         */
        public var componentName: kotlin.String? = null
        /**
         * The version of the component.
         */
        public var componentVersion: kotlin.String? = null
        /**
         * The time at which the component was created, expressed in ISO 8601 format.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the component version in IoT Greengrass V2. This status is different from the status of the component on a core device.
         */
        public var status: aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.CreateComponentVersionResponse) : this() {
            this.arn = x.arn
            this.componentName = x.componentName
            this.componentVersion = x.componentVersion
            this.creationTimestamp = x.creationTimestamp
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.CreateComponentVersionResponse = CreateComponentVersionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (componentName == null) componentName = ""
            if (componentVersion == null) componentVersion = ""
            if (creationTimestamp == null) creationTimestamp = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
