// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about an exponential rollout rate for a configuration deployment job.
 */
public class IotJobExponentialRolloutRate private constructor(builder: Builder) {
    /**
     * The minimum number of devices that receive a pending job notification, per minute, when the job starts. This parameter defines the initial rollout rate of the job.
     */
    public val baseRatePerMinute: kotlin.Int = requireNotNull(builder.baseRatePerMinute) { "A non-null value must be provided for baseRatePerMinute" }
    /**
     * The exponential factor to increase the rollout rate for the job.
     *
     * This parameter supports up to one digit after the decimal (for example, you can specify `1.5`, but not `1.55`).
     */
    public val incrementFactor: kotlin.Double = requireNotNull(builder.incrementFactor) { "A non-null value must be provided for incrementFactor" }
    /**
     * The criteria to increase the rollout rate for the job.
     */
    public val rateIncreaseCriteria: aws.sdk.kotlin.services.greengrassv2.model.IotJobRateIncreaseCriteria? = builder.rateIncreaseCriteria

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.IotJobExponentialRolloutRate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IotJobExponentialRolloutRate(")
        append("baseRatePerMinute=$baseRatePerMinute,")
        append("incrementFactor=$incrementFactor,")
        append("rateIncreaseCriteria=$rateIncreaseCriteria")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseRatePerMinute
        result = 31 * result + (incrementFactor.hashCode())
        result = 31 * result + (rateIncreaseCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IotJobExponentialRolloutRate

        if (baseRatePerMinute != other.baseRatePerMinute) return false
        if (!(incrementFactor?.equals(other.incrementFactor) ?: (other.incrementFactor == null))) return false
        if (rateIncreaseCriteria != other.rateIncreaseCriteria) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.IotJobExponentialRolloutRate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The minimum number of devices that receive a pending job notification, per minute, when the job starts. This parameter defines the initial rollout rate of the job.
         */
        public var baseRatePerMinute: kotlin.Int? = null
        /**
         * The exponential factor to increase the rollout rate for the job.
         *
         * This parameter supports up to one digit after the decimal (for example, you can specify `1.5`, but not `1.55`).
         */
        public var incrementFactor: kotlin.Double? = null
        /**
         * The criteria to increase the rollout rate for the job.
         */
        public var rateIncreaseCriteria: aws.sdk.kotlin.services.greengrassv2.model.IotJobRateIncreaseCriteria? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.IotJobExponentialRolloutRate) : this() {
            this.baseRatePerMinute = x.baseRatePerMinute
            this.incrementFactor = x.incrementFactor
            this.rateIncreaseCriteria = x.rateIncreaseCriteria
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.IotJobExponentialRolloutRate = IotJobExponentialRolloutRate(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.IotJobRateIncreaseCriteria] inside the given [block]
         */
        public fun rateIncreaseCriteria(block: aws.sdk.kotlin.services.greengrassv2.model.IotJobRateIncreaseCriteria.Builder.() -> kotlin.Unit) {
            this.rateIncreaseCriteria = aws.sdk.kotlin.services.greengrassv2.model.IotJobRateIncreaseCriteria.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (baseRatePerMinute == null) baseRatePerMinute = 0
            if (incrementFactor == null) incrementFactor = 0.0
            return this
        }
    }
}
