// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetComponentResponse private constructor(builder: Builder) {
    /**
     * The recipe of the component version.
     */
    public val recipe: kotlin.ByteArray = requireNotNull(builder.recipe) { "A non-null value must be provided for recipe" }
    /**
     * The format of the recipe.
     */
    public val recipeOutputFormat: aws.sdk.kotlin.services.greengrassv2.model.RecipeOutputFormat = requireNotNull(builder.recipeOutputFormat) { "A non-null value must be provided for recipeOutputFormat" }
    /**
     * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.GetComponentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetComponentResponse(")
        append("recipe=$recipe,")
        append("recipeOutputFormat=$recipeOutputFormat,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = recipe.contentHashCode()
        result = 31 * result + (recipeOutputFormat.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetComponentResponse

        if (recipe != null) {
            if (other.recipe == null) return false
            if (!recipe.contentEquals(other.recipe)) return false
        } else if (other.recipe != null) return false
        if (recipeOutputFormat != other.recipeOutputFormat) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.GetComponentResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The recipe of the component version.
         */
        public var recipe: kotlin.ByteArray? = null
        /**
         * The format of the recipe.
         */
        public var recipeOutputFormat: aws.sdk.kotlin.services.greengrassv2.model.RecipeOutputFormat? = null
        /**
         * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.GetComponentResponse) : this() {
            this.recipe = x.recipe
            this.recipeOutputFormat = x.recipeOutputFormat
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.GetComponentResponse = GetComponentResponse(this)

        internal fun correctErrors(): Builder {
            if (recipe == null) recipe = ByteArray(0)
            if (recipeOutputFormat == null) recipeOutputFormat = RecipeOutputFormat.SdkUnknown("no value provided")
            return this
        }
    }
}
