// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeComponentResponse private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the component version.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The name of the component.
     */
    public val componentName: kotlin.String? = builder.componentName
    /**
     * The version of the component.
     */
    public val componentVersion: kotlin.String? = builder.componentVersion
    /**
     * The time at which the component was created, expressed in ISO 8601 format.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The description of the component version.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The platforms that the component version supports.
     */
    public val platforms: List<ComponentPlatform>? = builder.platforms
    /**
     * The publisher of the component version.
     */
    public val publisher: kotlin.String? = builder.publisher
    /**
     * The status of the component version in IoT Greengrass V2. This status is different from the status of the component on a core device.
     */
    public val status: aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus? = builder.status
    /**
     * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.DescribeComponentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeComponentResponse(")
        append("arn=$arn,")
        append("componentName=$componentName,")
        append("componentVersion=$componentVersion,")
        append("creationTimestamp=$creationTimestamp,")
        append("description=$description,")
        append("platforms=$platforms,")
        append("publisher=$publisher,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (componentName?.hashCode() ?: 0)
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (platforms?.hashCode() ?: 0)
        result = 31 * result + (publisher?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeComponentResponse

        if (arn != other.arn) return false
        if (componentName != other.componentName) return false
        if (componentVersion != other.componentVersion) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (description != other.description) return false
        if (platforms != other.platforms) return false
        if (publisher != other.publisher) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.DescribeComponentResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the component version.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the component.
         */
        public var componentName: kotlin.String? = null
        /**
         * The version of the component.
         */
        public var componentVersion: kotlin.String? = null
        /**
         * The time at which the component was created, expressed in ISO 8601 format.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the component version.
         */
        public var description: kotlin.String? = null
        /**
         * The platforms that the component version supports.
         */
        public var platforms: List<ComponentPlatform>? = null
        /**
         * The publisher of the component version.
         */
        public var publisher: kotlin.String? = null
        /**
         * The status of the component version in IoT Greengrass V2. This status is different from the status of the component on a core device.
         */
        public var status: aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus? = null
        /**
         * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.DescribeComponentResponse) : this() {
            this.arn = x.arn
            this.componentName = x.componentName
            this.componentVersion = x.componentVersion
            this.creationTimestamp = x.creationTimestamp
            this.description = x.description
            this.platforms = x.platforms
            this.publisher = x.publisher
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.DescribeComponentResponse = DescribeComponentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
