// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a Greengrass core device, which is an IoT thing that runs the IoT Greengrass Core software.
 */
public class CoreDevice private constructor(builder: Builder) {
    /**
     * The name of the core device. This is also the name of the IoT thing.
     */
    public val coreDeviceThingName: kotlin.String? = builder.coreDeviceThingName
    /**
     * The time at which the core device's status last updated, expressed in ISO 8601 format.
     */
    public val lastStatusUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastStatusUpdateTimestamp
    /**
     * The status of the core device. Core devices can have the following statuses:
     * + `HEALTHY` – The IoT Greengrass Core software and all components run on the core device without issue.
     * + `UNHEALTHY` – The IoT Greengrass Core software or a component is in a failed state on the core device.
     */
    public val status: aws.sdk.kotlin.services.greengrassv2.model.CoreDeviceStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.CoreDevice = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CoreDevice(")
        append("coreDeviceThingName=$coreDeviceThingName,")
        append("lastStatusUpdateTimestamp=$lastStatusUpdateTimestamp,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = coreDeviceThingName?.hashCode() ?: 0
        result = 31 * result + (lastStatusUpdateTimestamp?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CoreDevice

        if (coreDeviceThingName != other.coreDeviceThingName) return false
        if (lastStatusUpdateTimestamp != other.lastStatusUpdateTimestamp) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.CoreDevice = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the core device. This is also the name of the IoT thing.
         */
        public var coreDeviceThingName: kotlin.String? = null
        /**
         * The time at which the core device's status last updated, expressed in ISO 8601 format.
         */
        public var lastStatusUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the core device. Core devices can have the following statuses:
         * + `HEALTHY` – The IoT Greengrass Core software and all components run on the core device without issue.
         * + `UNHEALTHY` – The IoT Greengrass Core software or a component is in a failed state on the core device.
         */
        public var status: aws.sdk.kotlin.services.greengrassv2.model.CoreDeviceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.CoreDevice) : this() {
            this.coreDeviceThingName = x.coreDeviceThingName
            this.lastStatusUpdateTimestamp = x.lastStatusUpdateTimestamp
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.CoreDevice = CoreDevice(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
