// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information system user and group that the IoT Greengrass Core software uses to run component processes on the core device. For more information, see [Configure the user and group that run components](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user) in the *IoT Greengrass V2 Developer Guide*.
 */
public class ComponentRunWith private constructor(builder: Builder) {
    /**
     * The POSIX system user and, optionally, group to use to run this component on Linux core devices. The user, and group if specified, must exist on each Linux core device. Specify the user and group separated by a colon (`:`) in the following format: `user:group`. The group is optional. If you don't specify a group, the IoT Greengrass Core software uses the primary user for the group.
     *
     * If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that you configure on the Greengrass nucleus component. For more information, see [Configure the user and group that run components](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user).
     */
    public val posixUser: kotlin.String? = builder.posixUser
    /**
     * The system resource limits to apply to this component's process on the core device. IoT Greengrass currently supports this feature on only Linux core devices.
     *
     * If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits that you configure on the Greengrass nucleus component. For more information, see [Configure system resource limits for components](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits).
     */
    public val systemResourceLimits: aws.sdk.kotlin.services.greengrassv2.model.SystemResourceLimits? = builder.systemResourceLimits
    /**
     * The Windows user to use to run this component on Windows core devices. The user must exist on each Windows core device, and its name and password must be in the LocalSystem account's Credentials Manager instance.
     *
     * If you omit this parameter, the IoT Greengrass Core software uses the default Windows user that you configure on the Greengrass nucleus component. For more information, see [Configure the user and group that run components](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user).
     */
    public val windowsUser: kotlin.String? = builder.windowsUser

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.ComponentRunWith = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentRunWith(")
        append("posixUser=$posixUser,")
        append("systemResourceLimits=$systemResourceLimits,")
        append("windowsUser=$windowsUser")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = posixUser?.hashCode() ?: 0
        result = 31 * result + (systemResourceLimits?.hashCode() ?: 0)
        result = 31 * result + (windowsUser?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComponentRunWith

        if (posixUser != other.posixUser) return false
        if (systemResourceLimits != other.systemResourceLimits) return false
        if (windowsUser != other.windowsUser) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.ComponentRunWith = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The POSIX system user and, optionally, group to use to run this component on Linux core devices. The user, and group if specified, must exist on each Linux core device. Specify the user and group separated by a colon (`:`) in the following format: `user:group`. The group is optional. If you don't specify a group, the IoT Greengrass Core software uses the primary user for the group.
         *
         * If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that you configure on the Greengrass nucleus component. For more information, see [Configure the user and group that run components](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user).
         */
        public var posixUser: kotlin.String? = null
        /**
         * The system resource limits to apply to this component's process on the core device. IoT Greengrass currently supports this feature on only Linux core devices.
         *
         * If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits that you configure on the Greengrass nucleus component. For more information, see [Configure system resource limits for components](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits).
         */
        public var systemResourceLimits: aws.sdk.kotlin.services.greengrassv2.model.SystemResourceLimits? = null
        /**
         * The Windows user to use to run this component on Windows core devices. The user must exist on each Windows core device, and its name and password must be in the LocalSystem account's Credentials Manager instance.
         *
         * If you omit this parameter, the IoT Greengrass Core software uses the default Windows user that you configure on the Greengrass nucleus component. For more information, see [Configure the user and group that run components](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user).
         */
        public var windowsUser: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.ComponentRunWith) : this() {
            this.posixUser = x.posixUser
            this.systemResourceLimits = x.systemResourceLimits
            this.windowsUser = x.windowsUser
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.ComponentRunWith = ComponentRunWith(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.SystemResourceLimits] inside the given [block]
         */
        public fun systemResourceLimits(block: aws.sdk.kotlin.services.greengrassv2.model.SystemResourceLimits.Builder.() -> kotlin.Unit) {
            this.systemResourceLimits = aws.sdk.kotlin.services.greengrassv2.model.SystemResourceLimits.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
