// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about a component that is a candidate to deploy to a Greengrass core device.
 */
public class ComponentCandidate private constructor(builder: Builder) {
    /**
     * The name of the component.
     */
    public val componentName: kotlin.String? = builder.componentName
    /**
     * The version of the component.
     */
    public val componentVersion: kotlin.String? = builder.componentVersion
    /**
     * The version requirements for the component's dependencies. Greengrass core devices get the version requirements from component recipes.
     *
     * IoT Greengrass V2 uses semantic version constraints. For more information, see [Semantic Versioning](https://semver.org/).
     */
    public val versionRequirements: Map<String, String>? = builder.versionRequirements

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.ComponentCandidate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentCandidate(")
        append("componentName=$componentName,")
        append("componentVersion=$componentVersion,")
        append("versionRequirements=$versionRequirements")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentName?.hashCode() ?: 0
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (versionRequirements?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComponentCandidate

        if (componentName != other.componentName) return false
        if (componentVersion != other.componentVersion) return false
        if (versionRequirements != other.versionRequirements) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.ComponentCandidate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the component.
         */
        public var componentName: kotlin.String? = null
        /**
         * The version of the component.
         */
        public var componentVersion: kotlin.String? = null
        /**
         * The version requirements for the component's dependencies. Greengrass core devices get the version requirements from component recipes.
         *
         * IoT Greengrass V2 uses semantic version constraints. For more information, see [Semantic Versioning](https://semver.org/).
         */
        public var versionRequirements: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.ComponentCandidate) : this() {
            this.componentName = x.componentName
            this.componentVersion = x.componentVersion
            this.versionRequirements = x.versionRequirements
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.ComponentCandidate = ComponentCandidate(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
