// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.greengrassv2.auth.DefaultGreengrassV2AuthSchemeProvider
import aws.sdk.kotlin.services.greengrassv2.auth.GreengrassV2AuthSchemeProvider
import aws.sdk.kotlin.services.greengrassv2.endpoints.DefaultGreengrassV2EndpointProvider
import aws.sdk.kotlin.services.greengrassv2.endpoints.GreengrassV2EndpointParameters
import aws.sdk.kotlin.services.greengrassv2.endpoints.GreengrassV2EndpointProvider
import aws.sdk.kotlin.services.greengrassv2.model.AssociateServiceRoleToAccountRequest
import aws.sdk.kotlin.services.greengrassv2.model.AssociateServiceRoleToAccountResponse
import aws.sdk.kotlin.services.greengrassv2.model.BatchAssociateClientDeviceWithCoreDeviceRequest
import aws.sdk.kotlin.services.greengrassv2.model.BatchAssociateClientDeviceWithCoreDeviceResponse
import aws.sdk.kotlin.services.greengrassv2.model.BatchDisassociateClientDeviceFromCoreDeviceRequest
import aws.sdk.kotlin.services.greengrassv2.model.BatchDisassociateClientDeviceFromCoreDeviceResponse
import aws.sdk.kotlin.services.greengrassv2.model.CancelDeploymentRequest
import aws.sdk.kotlin.services.greengrassv2.model.CancelDeploymentResponse
import aws.sdk.kotlin.services.greengrassv2.model.CreateComponentVersionRequest
import aws.sdk.kotlin.services.greengrassv2.model.CreateComponentVersionResponse
import aws.sdk.kotlin.services.greengrassv2.model.CreateDeploymentRequest
import aws.sdk.kotlin.services.greengrassv2.model.CreateDeploymentResponse
import aws.sdk.kotlin.services.greengrassv2.model.DeleteComponentRequest
import aws.sdk.kotlin.services.greengrassv2.model.DeleteComponentResponse
import aws.sdk.kotlin.services.greengrassv2.model.DeleteCoreDeviceRequest
import aws.sdk.kotlin.services.greengrassv2.model.DeleteCoreDeviceResponse
import aws.sdk.kotlin.services.greengrassv2.model.DeleteDeploymentRequest
import aws.sdk.kotlin.services.greengrassv2.model.DeleteDeploymentResponse
import aws.sdk.kotlin.services.greengrassv2.model.DescribeComponentRequest
import aws.sdk.kotlin.services.greengrassv2.model.DescribeComponentResponse
import aws.sdk.kotlin.services.greengrassv2.model.DisassociateServiceRoleFromAccountRequest
import aws.sdk.kotlin.services.greengrassv2.model.DisassociateServiceRoleFromAccountResponse
import aws.sdk.kotlin.services.greengrassv2.model.GetComponentRequest
import aws.sdk.kotlin.services.greengrassv2.model.GetComponentResponse
import aws.sdk.kotlin.services.greengrassv2.model.GetComponentVersionArtifactRequest
import aws.sdk.kotlin.services.greengrassv2.model.GetComponentVersionArtifactResponse
import aws.sdk.kotlin.services.greengrassv2.model.GetConnectivityInfoRequest
import aws.sdk.kotlin.services.greengrassv2.model.GetConnectivityInfoResponse
import aws.sdk.kotlin.services.greengrassv2.model.GetCoreDeviceRequest
import aws.sdk.kotlin.services.greengrassv2.model.GetCoreDeviceResponse
import aws.sdk.kotlin.services.greengrassv2.model.GetDeploymentRequest
import aws.sdk.kotlin.services.greengrassv2.model.GetDeploymentResponse
import aws.sdk.kotlin.services.greengrassv2.model.GetServiceRoleForAccountRequest
import aws.sdk.kotlin.services.greengrassv2.model.GetServiceRoleForAccountResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListComponentVersionsRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListComponentVersionsResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListComponentsRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListComponentsResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListCoreDevicesRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListCoreDevicesResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListDeploymentsRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListDeploymentsResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListEffectiveDeploymentsRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListEffectiveDeploymentsResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListInstalledComponentsRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListInstalledComponentsResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.greengrassv2.model.ResolveComponentCandidatesRequest
import aws.sdk.kotlin.services.greengrassv2.model.ResolveComponentCandidatesResponse
import aws.sdk.kotlin.services.greengrassv2.model.TagResourceRequest
import aws.sdk.kotlin.services.greengrassv2.model.TagResourceResponse
import aws.sdk.kotlin.services.greengrassv2.model.UntagResourceRequest
import aws.sdk.kotlin.services.greengrassv2.model.UntagResourceResponse
import aws.sdk.kotlin.services.greengrassv2.model.UpdateConnectivityInfoRequest
import aws.sdk.kotlin.services.greengrassv2.model.UpdateConnectivityInfoResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "GreengrassV2"
public const val SdkVersion: String = "1.3.1"
public const val ServiceApiVersion: String = "2020-11-30"

/**
 * IoT Greengrass brings local compute, messaging, data management, sync, and ML inference capabilities to edge devices. This enables devices to collect and analyze data closer to the source of information, react autonomously to local events, and communicate securely with each other on local networks. Local devices can also communicate securely with Amazon Web Services IoT Core and export IoT data to the Amazon Web Services Cloud. IoT Greengrass developers can use Lambda functions and components to create and deploy applications to fleets of edge devices for local operation.
 *
 * IoT Greengrass Version 2 provides a new major version of the IoT Greengrass Core software, new APIs, and a new console. Use this API reference to learn how to use the IoT Greengrass V2 API operations to manage components, manage deployments, and core devices.
 *
 * For more information, see [What is IoT Greengrass?](https://docs.aws.amazon.com/greengrass/v2/developerguide/what-is-iot-greengrass.html) in the *IoT Greengrass V2 Developer Guide*.
 */
public interface GreengrassV2Client : SdkClient {
    /**
     * GreengrassV2Client's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, GreengrassV2Client, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "GreengrassV2",
                "GREENGRASSV2",
                "greengrassv2",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, GreengrassV2Client>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): GreengrassV2Client = DefaultGreengrassV2Client(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: GreengrassV2EndpointProvider = builder.endpointProvider ?: DefaultGreengrassV2EndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: GreengrassV2AuthSchemeProvider = builder.authSchemeProvider ?: DefaultGreengrassV2AuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "GreengrassV2"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: GreengrassV2EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: GreengrassV2AuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a Greengrass service role with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device connectivity information. The role must include the [AWSGreengrassResourceAccessRolePolicy](https://console.aws.amazon.com/iam/home#/policies/arn:awsiam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy) managed policy or a custom policy that defines equivalent permissions for the IoT Greengrass features that you use. For more information, see [Greengrass service role](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html) in the *IoT Greengrass Version 2 Developer Guide*.
     */
    public suspend fun associateServiceRoleToAccount(input: AssociateServiceRoleToAccountRequest): AssociateServiceRoleToAccountResponse

    /**
     * Associates a list of client devices with a core device. Use this API operation to specify which client devices can discover a core device through cloud discovery. With cloud discovery, client devices connect to IoT Greengrass to retrieve associated core devices' connectivity information and certificates. For more information, see [Configure cloud discovery](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-cloud-discovery.html) in the *IoT Greengrass V2 Developer Guide*.
     *
     * Client devices are local IoT devices that connect to and communicate with an IoT Greengrass core device over MQTT. You can connect client devices to a core device to sync MQTT messages and data to Amazon Web Services IoT Core and interact with client devices in Greengrass components. For more information, see [Interact with local IoT devices](https://docs.aws.amazon.com/greengrass/v2/developerguide/interact-with-local-iot-devices.html) in the *IoT Greengrass V2 Developer Guide*.
     */
    public suspend fun batchAssociateClientDeviceWithCoreDevice(input: BatchAssociateClientDeviceWithCoreDeviceRequest): BatchAssociateClientDeviceWithCoreDeviceResponse

    /**
     * Disassociates a list of client devices from a core device. After you disassociate a client device from a core device, the client device won't be able to use cloud discovery to retrieve the core device's connectivity information and certificates.
     */
    public suspend fun batchDisassociateClientDeviceFromCoreDevice(input: BatchDisassociateClientDeviceFromCoreDeviceRequest): BatchDisassociateClientDeviceFromCoreDeviceResponse

    /**
     * Cancels a deployment. This operation cancels the deployment for devices that haven't yet received it. If a device already received the deployment, this operation doesn't change anything for that device.
     */
    public suspend fun cancelDeployment(input: CancelDeploymentRequest): CancelDeploymentResponse

    /**
     * Creates a component. Components are software that run on Greengrass core devices. After you develop and test a component on your core device, you can use this operation to upload your component to IoT Greengrass. Then, you can deploy the component to other core devices.
     *
     * You can use this operation to do the following:
     * + **Create components from recipes**Create a component from a recipe, which is a file that defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform capability. For more information, see [IoT Greengrass component recipe reference](https://docs.aws.amazon.com/greengrass/v2/developerguide/component-recipe-reference.html) in the *IoT Greengrass V2 Developer Guide*.To create a component from a recipe, specify `inlineRecipe` when you call this operation.
     * + **Create components from Lambda functions**Create a component from an Lambda function that runs on IoT Greengrass. This creates a recipe and artifacts from the Lambda function's deployment package. You can use this operation to migrate Lambda functions from IoT Greengrass V1 to IoT Greengrass V2.This function accepts Lambda functions in all supported versions of Python, Node.js, and Java runtimes. IoT Greengrass doesn't apply any additional restrictions on deprecated Lambda runtime versions.To create a component from a Lambda function, specify `lambdaFunction` when you call this operation.IoT Greengrass currently supports Lambda functions on only Linux core devices.
     */
    public suspend fun createComponentVersion(input: CreateComponentVersionRequest = CreateComponentVersionRequest { }): CreateComponentVersionResponse

    /**
     * Creates a continuous deployment for a target, which is a Greengrass core device or group of core devices. When you add a new core device to a group of core devices that has a deployment, IoT Greengrass deploys that group's deployment to the new device.
     *
     * You can define one deployment for each target. When you create a new deployment for a target that has an existing deployment, you replace the previous deployment. IoT Greengrass applies the new deployment to the target devices.
     *
     * Every deployment has a revision number that indicates how many deployment revisions you define for a target. Use this operation to create a new revision of an existing deployment.
     *
     * For more information, see the [Create deployments](https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html) in the *IoT Greengrass V2 Developer Guide*.
     */
    public suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Deletes a version of a component from IoT Greengrass.
     *
     * This operation deletes the component's recipe and artifacts. As a result, deployments that refer to this component version will fail. If you have deployments that use this component version, you can remove the component from the deployment or update the deployment to use a valid version.
     */
    public suspend fun deleteComponent(input: DeleteComponentRequest): DeleteComponentResponse

    /**
     * Deletes a Greengrass core device, which is an IoT thing. This operation removes the core device from the list of core devices. This operation doesn't delete the IoT thing. For more information about how to delete the IoT thing, see [DeleteThing](https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThing.html) in the *IoT API Reference*.
     */
    public suspend fun deleteCoreDevice(input: DeleteCoreDeviceRequest): DeleteCoreDeviceResponse

    /**
     * Deletes a deployment. To delete an active deployment, you must first cancel it. For more information, see [CancelDeployment](https://docs.aws.amazon.com/iot/latest/apireference/API_CancelDeployment.html).
     *
     * Deleting a deployment doesn't affect core devices that run that deployment, because core devices store the deployment's configuration on the device. Additionally, core devices can roll back to a previous deployment that has been deleted.
     */
    public suspend fun deleteDeployment(input: DeleteDeploymentRequest): DeleteDeploymentResponse

    /**
     * Retrieves metadata for a version of a component.
     */
    public suspend fun describeComponent(input: DescribeComponentRequest): DescribeComponentResponse

    /**
     * Disassociates the Greengrass service role from IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. Without a service role, IoT Greengrass can't verify the identity of client devices or manage core device connectivity information. For more information, see [Greengrass service role](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html) in the *IoT Greengrass Version 2 Developer Guide*.
     */
    public suspend fun disassociateServiceRoleFromAccount(input: DisassociateServiceRoleFromAccountRequest = DisassociateServiceRoleFromAccountRequest { }): DisassociateServiceRoleFromAccountResponse

    /**
     * Gets the recipe for a version of a component.
     */
    public suspend fun getComponent(input: GetComponentRequest): GetComponentResponse

    /**
     * Gets the pre-signed URL to download a public or a Lambda component artifact. Core devices call this operation to identify the URL that they can use to download an artifact to install.
     */
    public suspend fun getComponentVersionArtifact(input: GetComponentVersionArtifactRequest): GetComponentVersionArtifactResponse

    /**
     * Retrieves connectivity information for a Greengrass core device.
     *
     * Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the core device. When a client device calls the [IoT Greengrass discovery API](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html), IoT Greengrass returns connectivity information for all of the core devices where the client device can connect. For more information, see [Connect client devices to core devices](https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html) in the *IoT Greengrass Version 2 Developer Guide*.
     */
    public suspend fun getConnectivityInfo(input: GetConnectivityInfoRequest): GetConnectivityInfoResponse

    /**
     * Retrieves metadata for a Greengrass core device.
     *
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services Cloud, then the reported status of that device might not reflect its current status. The status timestamp indicates when the device status was last updated.
     *
     * Core devices send status updates at the following times:
     * + When the IoT Greengrass Core software starts
     * + When the core device receives a deployment from the Amazon Web Services Cloud
     * + When the status of any component on the core device becomes `BROKEN`
     * + At a [regular interval that you can configure](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss), which defaults to 24 hours
     * + For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     */
    public suspend fun getCoreDevice(input: GetCoreDeviceRequest): GetCoreDeviceResponse

    /**
     * Gets a deployment. Deployments define the components that run on Greengrass core devices.
     */
    public suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse

    /**
     * Gets the service role associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device connectivity information. For more information, see [Greengrass service role](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html) in the *IoT Greengrass Version 2 Developer Guide*.
     */
    public suspend fun getServiceRoleForAccount(input: GetServiceRoleForAccountRequest = GetServiceRoleForAccountRequest { }): GetServiceRoleForAccountResponse

    /**
     * Retrieves a paginated list of client devices that are associated with a core device.
     */
    public suspend fun listClientDevicesAssociatedWithCoreDevice(input: ListClientDevicesAssociatedWithCoreDeviceRequest): ListClientDevicesAssociatedWithCoreDeviceResponse

    /**
     * Retrieves a paginated list of all versions for a component. Greater versions are listed first.
     */
    public suspend fun listComponentVersions(input: ListComponentVersionsRequest): ListComponentVersionsResponse

    /**
     * Retrieves a paginated list of component summaries. This list includes components that you have permission to view.
     */
    public suspend fun listComponents(input: ListComponentsRequest = ListComponentsRequest { }): ListComponentsResponse

    /**
     * Retrieves a paginated list of Greengrass core devices.
     *
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services Cloud, then the reported status of that device might not reflect its current status. The status timestamp indicates when the device status was last updated.
     *
     * Core devices send status updates at the following times:
     * + When the IoT Greengrass Core software starts
     * + When the core device receives a deployment from the Amazon Web Services Cloud
     * + When the status of any component on the core device becomes `BROKEN`
     * + At a [regular interval that you can configure](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss), which defaults to 24 hours
     * + For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     */
    public suspend fun listCoreDevices(input: ListCoreDevicesRequest = ListCoreDevicesRequest { }): ListCoreDevicesResponse

    /**
     * Retrieves a paginated list of deployments.
     */
    public suspend fun listDeployments(input: ListDeploymentsRequest = ListDeploymentsRequest { }): ListDeploymentsResponse

    /**
     * Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core devices.
     */
    public suspend fun listEffectiveDeployments(input: ListEffectiveDeploymentsRequest): ListEffectiveDeploymentsResponse

    /**
     * Retrieves a paginated list of the components that a Greengrass core device runs. By default, this list doesn't include components that are deployed as dependencies of other components. To include dependencies in the response, set the `topologyFilter` parameter to `ALL`.
     *
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services Cloud, then the reported status of that device might not reflect its current status. The status timestamp indicates when the device status was last updated.
     *
     * Core devices send status updates at the following times:
     * + When the IoT Greengrass Core software starts
     * + When the core device receives a deployment from the Amazon Web Services Cloud
     * + When the status of any component on the core device becomes `BROKEN`
     * + At a [regular interval that you can configure](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss), which defaults to 24 hours
     * + For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     */
    public suspend fun listInstalledComponents(input: ListInstalledComponentsRequest): ListInstalledComponentsResponse

    /**
     * Retrieves the list of tags for an IoT Greengrass resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a list of components that meet the component, version, and platform requirements of a deployment. Greengrass core devices call this operation when they receive a deployment to identify the components to install.
     *
     * This operation identifies components that meet all dependency requirements for a deployment. If the requirements conflict, then this operation returns an error and the deployment fails. For example, this occurs if component `A` requires version `>2.0.0` and component `B` requires version `<2.0.0` of a component dependency.
     *
     * When you specify the component candidates to resolve, IoT Greengrass compares each component's digest from the core device with the component's digest in the Amazon Web Services Cloud. If the digests don't match, then IoT Greengrass specifies to use the version from the Amazon Web Services Cloud.
     *
     * To use this operation, you must use the data plane API endpoint and authenticate with an IoT device certificate. For more information, see [IoT Greengrass endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/greengrass.html).
     */
    public suspend fun resolveComponentCandidates(input: ResolveComponentCandidatesRequest = ResolveComponentCandidatesRequest { }): ResolveComponentCandidatesResponse

    /**
     * Adds tags to an IoT Greengrass resource. If a tag already exists for the resource, this operation updates the tag's value.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from an IoT Greengrass resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates connectivity information for a Greengrass core device.
     *
     * Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the core device. When a client device calls the [IoT Greengrass discovery API](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html), IoT Greengrass returns connectivity information for all of the core devices where the client device can connect. For more information, see [Connect client devices to core devices](https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html) in the *IoT Greengrass Version 2 Developer Guide*.
     */
    public suspend fun updateConnectivityInfo(input: UpdateConnectivityInfoRequest): UpdateConnectivityInfoResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun GreengrassV2Client.withConfig(block: GreengrassV2Client.Config.Builder.() -> Unit): GreengrassV2Client {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultGreengrassV2Client(newConfig)
}

/**
 * Associates a Greengrass service role with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device connectivity information. The role must include the [AWSGreengrassResourceAccessRolePolicy](https://console.aws.amazon.com/iam/home#/policies/arn:awsiam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy) managed policy or a custom policy that defines equivalent permissions for the IoT Greengrass features that you use. For more information, see [Greengrass service role](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html) in the *IoT Greengrass Version 2 Developer Guide*.
 */
public suspend inline fun GreengrassV2Client.associateServiceRoleToAccount(crossinline block: AssociateServiceRoleToAccountRequest.Builder.() -> Unit): AssociateServiceRoleToAccountResponse = associateServiceRoleToAccount(AssociateServiceRoleToAccountRequest.Builder().apply(block).build())

/**
 * Associates a list of client devices with a core device. Use this API operation to specify which client devices can discover a core device through cloud discovery. With cloud discovery, client devices connect to IoT Greengrass to retrieve associated core devices' connectivity information and certificates. For more information, see [Configure cloud discovery](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-cloud-discovery.html) in the *IoT Greengrass V2 Developer Guide*.
 *
 * Client devices are local IoT devices that connect to and communicate with an IoT Greengrass core device over MQTT. You can connect client devices to a core device to sync MQTT messages and data to Amazon Web Services IoT Core and interact with client devices in Greengrass components. For more information, see [Interact with local IoT devices](https://docs.aws.amazon.com/greengrass/v2/developerguide/interact-with-local-iot-devices.html) in the *IoT Greengrass V2 Developer Guide*.
 */
public suspend inline fun GreengrassV2Client.batchAssociateClientDeviceWithCoreDevice(crossinline block: BatchAssociateClientDeviceWithCoreDeviceRequest.Builder.() -> Unit): BatchAssociateClientDeviceWithCoreDeviceResponse = batchAssociateClientDeviceWithCoreDevice(BatchAssociateClientDeviceWithCoreDeviceRequest.Builder().apply(block).build())

/**
 * Disassociates a list of client devices from a core device. After you disassociate a client device from a core device, the client device won't be able to use cloud discovery to retrieve the core device's connectivity information and certificates.
 */
public suspend inline fun GreengrassV2Client.batchDisassociateClientDeviceFromCoreDevice(crossinline block: BatchDisassociateClientDeviceFromCoreDeviceRequest.Builder.() -> Unit): BatchDisassociateClientDeviceFromCoreDeviceResponse = batchDisassociateClientDeviceFromCoreDevice(BatchDisassociateClientDeviceFromCoreDeviceRequest.Builder().apply(block).build())

/**
 * Cancels a deployment. This operation cancels the deployment for devices that haven't yet received it. If a device already received the deployment, this operation doesn't change anything for that device.
 */
public suspend inline fun GreengrassV2Client.cancelDeployment(crossinline block: CancelDeploymentRequest.Builder.() -> Unit): CancelDeploymentResponse = cancelDeployment(CancelDeploymentRequest.Builder().apply(block).build())

/**
 * Creates a component. Components are software that run on Greengrass core devices. After you develop and test a component on your core device, you can use this operation to upload your component to IoT Greengrass. Then, you can deploy the component to other core devices.
 *
 * You can use this operation to do the following:
 * + **Create components from recipes**Create a component from a recipe, which is a file that defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform capability. For more information, see [IoT Greengrass component recipe reference](https://docs.aws.amazon.com/greengrass/v2/developerguide/component-recipe-reference.html) in the *IoT Greengrass V2 Developer Guide*.To create a component from a recipe, specify `inlineRecipe` when you call this operation.
 * + **Create components from Lambda functions**Create a component from an Lambda function that runs on IoT Greengrass. This creates a recipe and artifacts from the Lambda function's deployment package. You can use this operation to migrate Lambda functions from IoT Greengrass V1 to IoT Greengrass V2.This function accepts Lambda functions in all supported versions of Python, Node.js, and Java runtimes. IoT Greengrass doesn't apply any additional restrictions on deprecated Lambda runtime versions.To create a component from a Lambda function, specify `lambdaFunction` when you call this operation.IoT Greengrass currently supports Lambda functions on only Linux core devices.
 */
public suspend inline fun GreengrassV2Client.createComponentVersion(crossinline block: CreateComponentVersionRequest.Builder.() -> Unit): CreateComponentVersionResponse = createComponentVersion(CreateComponentVersionRequest.Builder().apply(block).build())

/**
 * Creates a continuous deployment for a target, which is a Greengrass core device or group of core devices. When you add a new core device to a group of core devices that has a deployment, IoT Greengrass deploys that group's deployment to the new device.
 *
 * You can define one deployment for each target. When you create a new deployment for a target that has an existing deployment, you replace the previous deployment. IoT Greengrass applies the new deployment to the target devices.
 *
 * Every deployment has a revision number that indicates how many deployment revisions you define for a target. Use this operation to create a new revision of an existing deployment.
 *
 * For more information, see the [Create deployments](https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html) in the *IoT Greengrass V2 Developer Guide*.
 */
public suspend inline fun GreengrassV2Client.createDeployment(crossinline block: CreateDeploymentRequest.Builder.() -> Unit): CreateDeploymentResponse = createDeployment(CreateDeploymentRequest.Builder().apply(block).build())

/**
 * Deletes a version of a component from IoT Greengrass.
 *
 * This operation deletes the component's recipe and artifacts. As a result, deployments that refer to this component version will fail. If you have deployments that use this component version, you can remove the component from the deployment or update the deployment to use a valid version.
 */
public suspend inline fun GreengrassV2Client.deleteComponent(crossinline block: DeleteComponentRequest.Builder.() -> Unit): DeleteComponentResponse = deleteComponent(DeleteComponentRequest.Builder().apply(block).build())

/**
 * Deletes a Greengrass core device, which is an IoT thing. This operation removes the core device from the list of core devices. This operation doesn't delete the IoT thing. For more information about how to delete the IoT thing, see [DeleteThing](https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThing.html) in the *IoT API Reference*.
 */
public suspend inline fun GreengrassV2Client.deleteCoreDevice(crossinline block: DeleteCoreDeviceRequest.Builder.() -> Unit): DeleteCoreDeviceResponse = deleteCoreDevice(DeleteCoreDeviceRequest.Builder().apply(block).build())

/**
 * Deletes a deployment. To delete an active deployment, you must first cancel it. For more information, see [CancelDeployment](https://docs.aws.amazon.com/iot/latest/apireference/API_CancelDeployment.html).
 *
 * Deleting a deployment doesn't affect core devices that run that deployment, because core devices store the deployment's configuration on the device. Additionally, core devices can roll back to a previous deployment that has been deleted.
 */
public suspend inline fun GreengrassV2Client.deleteDeployment(crossinline block: DeleteDeploymentRequest.Builder.() -> Unit): DeleteDeploymentResponse = deleteDeployment(DeleteDeploymentRequest.Builder().apply(block).build())

/**
 * Retrieves metadata for a version of a component.
 */
public suspend inline fun GreengrassV2Client.describeComponent(crossinline block: DescribeComponentRequest.Builder.() -> Unit): DescribeComponentResponse = describeComponent(DescribeComponentRequest.Builder().apply(block).build())

/**
 * Disassociates the Greengrass service role from IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. Without a service role, IoT Greengrass can't verify the identity of client devices or manage core device connectivity information. For more information, see [Greengrass service role](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html) in the *IoT Greengrass Version 2 Developer Guide*.
 */
public suspend inline fun GreengrassV2Client.disassociateServiceRoleFromAccount(crossinline block: DisassociateServiceRoleFromAccountRequest.Builder.() -> Unit): DisassociateServiceRoleFromAccountResponse = disassociateServiceRoleFromAccount(DisassociateServiceRoleFromAccountRequest.Builder().apply(block).build())

/**
 * Gets the recipe for a version of a component.
 */
public suspend inline fun GreengrassV2Client.getComponent(crossinline block: GetComponentRequest.Builder.() -> Unit): GetComponentResponse = getComponent(GetComponentRequest.Builder().apply(block).build())

/**
 * Gets the pre-signed URL to download a public or a Lambda component artifact. Core devices call this operation to identify the URL that they can use to download an artifact to install.
 */
public suspend inline fun GreengrassV2Client.getComponentVersionArtifact(crossinline block: GetComponentVersionArtifactRequest.Builder.() -> Unit): GetComponentVersionArtifactResponse = getComponentVersionArtifact(GetComponentVersionArtifactRequest.Builder().apply(block).build())

/**
 * Retrieves connectivity information for a Greengrass core device.
 *
 * Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the core device. When a client device calls the [IoT Greengrass discovery API](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html), IoT Greengrass returns connectivity information for all of the core devices where the client device can connect. For more information, see [Connect client devices to core devices](https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html) in the *IoT Greengrass Version 2 Developer Guide*.
 */
public suspend inline fun GreengrassV2Client.getConnectivityInfo(crossinline block: GetConnectivityInfoRequest.Builder.() -> Unit): GetConnectivityInfoResponse = getConnectivityInfo(GetConnectivityInfoRequest.Builder().apply(block).build())

/**
 * Retrieves metadata for a Greengrass core device.
 *
 * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services Cloud, then the reported status of that device might not reflect its current status. The status timestamp indicates when the device status was last updated.
 *
 * Core devices send status updates at the following times:
 * + When the IoT Greengrass Core software starts
 * + When the core device receives a deployment from the Amazon Web Services Cloud
 * + When the status of any component on the core device becomes `BROKEN`
 * + At a [regular interval that you can configure](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss), which defaults to 24 hours
 * + For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
 */
public suspend inline fun GreengrassV2Client.getCoreDevice(crossinline block: GetCoreDeviceRequest.Builder.() -> Unit): GetCoreDeviceResponse = getCoreDevice(GetCoreDeviceRequest.Builder().apply(block).build())

/**
 * Gets a deployment. Deployments define the components that run on Greengrass core devices.
 */
public suspend inline fun GreengrassV2Client.getDeployment(crossinline block: GetDeploymentRequest.Builder.() -> Unit): GetDeploymentResponse = getDeployment(GetDeploymentRequest.Builder().apply(block).build())

/**
 * Gets the service role associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device connectivity information. For more information, see [Greengrass service role](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html) in the *IoT Greengrass Version 2 Developer Guide*.
 */
public suspend inline fun GreengrassV2Client.getServiceRoleForAccount(crossinline block: GetServiceRoleForAccountRequest.Builder.() -> Unit): GetServiceRoleForAccountResponse = getServiceRoleForAccount(GetServiceRoleForAccountRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of client devices that are associated with a core device.
 */
public suspend inline fun GreengrassV2Client.listClientDevicesAssociatedWithCoreDevice(crossinline block: ListClientDevicesAssociatedWithCoreDeviceRequest.Builder.() -> Unit): ListClientDevicesAssociatedWithCoreDeviceResponse = listClientDevicesAssociatedWithCoreDevice(ListClientDevicesAssociatedWithCoreDeviceRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of all versions for a component. Greater versions are listed first.
 */
public suspend inline fun GreengrassV2Client.listComponentVersions(crossinline block: ListComponentVersionsRequest.Builder.() -> Unit): ListComponentVersionsResponse = listComponentVersions(ListComponentVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of component summaries. This list includes components that you have permission to view.
 */
public suspend inline fun GreengrassV2Client.listComponents(crossinline block: ListComponentsRequest.Builder.() -> Unit): ListComponentsResponse = listComponents(ListComponentsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of Greengrass core devices.
 *
 * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services Cloud, then the reported status of that device might not reflect its current status. The status timestamp indicates when the device status was last updated.
 *
 * Core devices send status updates at the following times:
 * + When the IoT Greengrass Core software starts
 * + When the core device receives a deployment from the Amazon Web Services Cloud
 * + When the status of any component on the core device becomes `BROKEN`
 * + At a [regular interval that you can configure](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss), which defaults to 24 hours
 * + For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
 */
public suspend inline fun GreengrassV2Client.listCoreDevices(crossinline block: ListCoreDevicesRequest.Builder.() -> Unit): ListCoreDevicesResponse = listCoreDevices(ListCoreDevicesRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of deployments.
 */
public suspend inline fun GreengrassV2Client.listDeployments(crossinline block: ListDeploymentsRequest.Builder.() -> Unit): ListDeploymentsResponse = listDeployments(ListDeploymentsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core devices.
 */
public suspend inline fun GreengrassV2Client.listEffectiveDeployments(crossinline block: ListEffectiveDeploymentsRequest.Builder.() -> Unit): ListEffectiveDeploymentsResponse = listEffectiveDeployments(ListEffectiveDeploymentsRequest.Builder().apply(block).build())

/**
 * Retrieves a paginated list of the components that a Greengrass core device runs. By default, this list doesn't include components that are deployed as dependencies of other components. To include dependencies in the response, set the `topologyFilter` parameter to `ALL`.
 *
 * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services Cloud, then the reported status of that device might not reflect its current status. The status timestamp indicates when the device status was last updated.
 *
 * Core devices send status updates at the following times:
 * + When the IoT Greengrass Core software starts
 * + When the core device receives a deployment from the Amazon Web Services Cloud
 * + When the status of any component on the core device becomes `BROKEN`
 * + At a [regular interval that you can configure](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss), which defaults to 24 hours
 * + For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
 */
public suspend inline fun GreengrassV2Client.listInstalledComponents(crossinline block: ListInstalledComponentsRequest.Builder.() -> Unit): ListInstalledComponentsResponse = listInstalledComponents(ListInstalledComponentsRequest.Builder().apply(block).build())

/**
 * Retrieves the list of tags for an IoT Greengrass resource.
 */
public suspend inline fun GreengrassV2Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves a list of components that meet the component, version, and platform requirements of a deployment. Greengrass core devices call this operation when they receive a deployment to identify the components to install.
 *
 * This operation identifies components that meet all dependency requirements for a deployment. If the requirements conflict, then this operation returns an error and the deployment fails. For example, this occurs if component `A` requires version `>2.0.0` and component `B` requires version `<2.0.0` of a component dependency.
 *
 * When you specify the component candidates to resolve, IoT Greengrass compares each component's digest from the core device with the component's digest in the Amazon Web Services Cloud. If the digests don't match, then IoT Greengrass specifies to use the version from the Amazon Web Services Cloud.
 *
 * To use this operation, you must use the data plane API endpoint and authenticate with an IoT device certificate. For more information, see [IoT Greengrass endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/greengrass.html).
 */
public suspend inline fun GreengrassV2Client.resolveComponentCandidates(crossinline block: ResolveComponentCandidatesRequest.Builder.() -> Unit): ResolveComponentCandidatesResponse = resolveComponentCandidates(ResolveComponentCandidatesRequest.Builder().apply(block).build())

/**
 * Adds tags to an IoT Greengrass resource. If a tag already exists for the resource, this operation updates the tag's value.
 */
public suspend inline fun GreengrassV2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from an IoT Greengrass resource.
 */
public suspend inline fun GreengrassV2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates connectivity information for a Greengrass core device.
 *
 * Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the core device. When a client device calls the [IoT Greengrass discovery API](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html), IoT Greengrass returns connectivity information for all of the core devices where the client device can connect. For more information, see [Connect client devices to core devices](https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html) in the *IoT Greengrass Version 2 Developer Guide*.
 */
public suspend inline fun GreengrassV2Client.updateConnectivityInfo(crossinline block: UpdateConnectivityInfoRequest.Builder.() -> Unit): UpdateConnectivityInfoResponse = updateConnectivityInfo(UpdateConnectivityInfoRequest.Builder().apply(block).build())
