// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.serde

import aws.sdk.kotlin.services.greengrassv2.model.ComponentDeploymentSpecification
import aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration
import aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies
import aws.sdk.kotlin.services.greengrassv2.model.DeploymentStatus
import aws.sdk.kotlin.services.greengrassv2.model.GetDeploymentResponse
import aws.sdk.kotlin.services.greengrassv2.model.GreengrassV2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class GetDeploymentOperationDeserializer: HttpDeserializer.NonStreaming<GetDeploymentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetDeploymentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDeploymentError(context, call, payload)
        }
        val builder = GetDeploymentResponse.Builder()

        if (payload != null) {
            deserializeGetDeploymentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetDeploymentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GreengrassV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GreengrassV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDeploymentOperationBody(builder: GetDeploymentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPONENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("components"))
    val CREATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTimestamp"))
    val DEPLOYMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentId"))
    val DEPLOYMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentName"))
    val DEPLOYMENTPOLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deploymentPolicies"))
    val DEPLOYMENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("deploymentStatus"))
    val IOTJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("iotJobArn"))
    val IOTJOBCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("iotJobConfiguration"))
    val IOTJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("iotJobId"))
    val ISLATESTFORTARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isLatestForTarget"))
    val PARENTTARGETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentTargetArn"))
    val REVISIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("revisionId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TARGETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPONENTS_DESCRIPTOR)
        field(CREATIONTIMESTAMP_DESCRIPTOR)
        field(DEPLOYMENTID_DESCRIPTOR)
        field(DEPLOYMENTNAME_DESCRIPTOR)
        field(DEPLOYMENTPOLICIES_DESCRIPTOR)
        field(DEPLOYMENTSTATUS_DESCRIPTOR)
        field(IOTJOBARN_DESCRIPTOR)
        field(IOTJOBCONFIGURATION_DESCRIPTOR)
        field(IOTJOBID_DESCRIPTOR)
        field(ISLATESTFORTARGET_DESCRIPTOR)
        field(PARENTTARGETARN_DESCRIPTOR)
        field(REVISIONID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TARGETARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPONENTS_DESCRIPTOR.index -> builder.components =
                    deserializer.deserializeMap(COMPONENTS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, ComponentDeploymentSpecification>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeComponentDeploymentSpecificationDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                CREATIONTIMESTAMP_DESCRIPTOR.index -> builder.creationTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEPLOYMENTID_DESCRIPTOR.index -> builder.deploymentId = deserializeString()
                DEPLOYMENTNAME_DESCRIPTOR.index -> builder.deploymentName = deserializeString()
                DEPLOYMENTPOLICIES_DESCRIPTOR.index -> builder.deploymentPolicies = deserializeDeploymentPoliciesDocument(deserializer)
                DEPLOYMENTSTATUS_DESCRIPTOR.index -> builder.deploymentStatus = deserializeString().let { DeploymentStatus.fromValue(it) }
                IOTJOBARN_DESCRIPTOR.index -> builder.iotJobArn = deserializeString()
                IOTJOBCONFIGURATION_DESCRIPTOR.index -> builder.iotJobConfiguration = deserializeDeploymentIotJobConfigurationDocument(deserializer)
                IOTJOBID_DESCRIPTOR.index -> builder.iotJobId = deserializeString()
                ISLATESTFORTARGET_DESCRIPTOR.index -> builder.isLatestForTarget = deserializeBoolean()
                PARENTTARGETARN_DESCRIPTOR.index -> builder.parentTargetArn = deserializeString()
                REVISIONID_DESCRIPTOR.index -> builder.revisionId = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TARGETARN_DESCRIPTOR.index -> builder.targetArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
