// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about policies that define how a deployment updates components and handles failure.
 */
public class DeploymentPolicies private constructor(builder: Builder) {
    /**
     * The component update policy for the configuration deployment. This policy defines when it's safe to deploy the configuration to devices.
     */
    public val componentUpdatePolicy: aws.sdk.kotlin.services.greengrassv2.model.DeploymentComponentUpdatePolicy? = builder.componentUpdatePolicy
    /**
     * The configuration validation policy for the configuration deployment. This policy defines how long each component has to validate its configure updates.
     */
    public val configurationValidationPolicy: aws.sdk.kotlin.services.greengrassv2.model.DeploymentConfigurationValidationPolicy? = builder.configurationValidationPolicy
    /**
     * The failure handling policy for the configuration deployment. This policy defines what to do if the deployment fails.
     *
     * Default: `ROLLBACK`
     */
    public val failureHandlingPolicy: aws.sdk.kotlin.services.greengrassv2.model.DeploymentFailureHandlingPolicy? = builder.failureHandlingPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentPolicies(")
        append("componentUpdatePolicy=$componentUpdatePolicy,")
        append("configurationValidationPolicy=$configurationValidationPolicy,")
        append("failureHandlingPolicy=$failureHandlingPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentUpdatePolicy?.hashCode() ?: 0
        result = 31 * result + (configurationValidationPolicy?.hashCode() ?: 0)
        result = 31 * result + (failureHandlingPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentPolicies

        if (componentUpdatePolicy != other.componentUpdatePolicy) return false
        if (configurationValidationPolicy != other.configurationValidationPolicy) return false
        if (failureHandlingPolicy != other.failureHandlingPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The component update policy for the configuration deployment. This policy defines when it's safe to deploy the configuration to devices.
         */
        public var componentUpdatePolicy: aws.sdk.kotlin.services.greengrassv2.model.DeploymentComponentUpdatePolicy? = null
        /**
         * The configuration validation policy for the configuration deployment. This policy defines how long each component has to validate its configure updates.
         */
        public var configurationValidationPolicy: aws.sdk.kotlin.services.greengrassv2.model.DeploymentConfigurationValidationPolicy? = null
        /**
         * The failure handling policy for the configuration deployment. This policy defines what to do if the deployment fails.
         *
         * Default: `ROLLBACK`
         */
        public var failureHandlingPolicy: aws.sdk.kotlin.services.greengrassv2.model.DeploymentFailureHandlingPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies) : this() {
            this.componentUpdatePolicy = x.componentUpdatePolicy
            this.configurationValidationPolicy = x.configurationValidationPolicy
            this.failureHandlingPolicy = x.failureHandlingPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies = DeploymentPolicies(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentComponentUpdatePolicy] inside the given [block]
         */
        public fun componentUpdatePolicy(block: aws.sdk.kotlin.services.greengrassv2.model.DeploymentComponentUpdatePolicy.Builder.() -> kotlin.Unit) {
            this.componentUpdatePolicy = aws.sdk.kotlin.services.greengrassv2.model.DeploymentComponentUpdatePolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentConfigurationValidationPolicy] inside the given [block]
         */
        public fun configurationValidationPolicy(block: aws.sdk.kotlin.services.greengrassv2.model.DeploymentConfigurationValidationPolicy.Builder.() -> kotlin.Unit) {
            this.configurationValidationPolicy = aws.sdk.kotlin.services.greengrassv2.model.DeploymentConfigurationValidationPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
