// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



public class ListCoreDevicesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of results to be returned per paginated request.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to be used for the next set of paginated results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The core device status by which to filter. If you specify this parameter, the list includes only core devices that have this status. Choose one of the following options:
     * + `HEALTHY` – The IoT Greengrass Core software and all components run on the core device without issue.
     * + `UNHEALTHY` – The IoT Greengrass Core software or a component is in a failed state on the core device.
     */
    public val status: aws.sdk.kotlin.services.greengrassv2.model.CoreDeviceStatus? = builder.status
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IoT thing group by which to filter. If you specify this parameter, the list includes only core devices that have successfully deployed a deployment that targets the thing group. When you remove a core device from a thing group, the list continues to include that core device.
     */
    public val thingGroupArn: kotlin.String? = builder.thingGroupArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.ListCoreDevicesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListCoreDevicesRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("status=$status,")
        append("thingGroupArn=$thingGroupArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (thingGroupArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListCoreDevicesRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false
        if (thingGroupArn != other.thingGroupArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.ListCoreDevicesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of results to be returned per paginated request.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to be used for the next set of paginated results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The core device status by which to filter. If you specify this parameter, the list includes only core devices that have this status. Choose one of the following options:
         * + `HEALTHY` – The IoT Greengrass Core software and all components run on the core device without issue.
         * + `UNHEALTHY` – The IoT Greengrass Core software or a component is in a failed state on the core device.
         */
        public var status: aws.sdk.kotlin.services.greengrassv2.model.CoreDeviceStatus? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IoT thing group by which to filter. If you specify this parameter, the list includes only core devices that have successfully deployed a deployment that targets the thing group. When you remove a core device from a thing group, the list continues to include that core device.
         */
        public var thingGroupArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.ListCoreDevicesRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.status = x.status
            this.thingGroupArn = x.thingGroupArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.ListCoreDevicesRequest = ListCoreDevicesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
