// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a volume that Linux processes in a container can access. When you define a volume, the IoT Greengrass Core software mounts the source files to the destination inside the container.
 */
public class LambdaVolumeMount private constructor(builder: Builder) {
    /**
     * Whether or not to add the IoT Greengrass user group as an owner of the volume.
     *
     * Default: `false`
     */
    public val addGroupOwner: kotlin.Boolean? = builder.addGroupOwner
    /**
     * The path to the logical volume in the file system.
     */
    public val destinationPath: kotlin.String = requireNotNull(builder.destinationPath) { "A non-null value must be provided for destinationPath" }
    /**
     * The permission to access the volume: read/only (`ro`) or read/write (`rw`).
     *
     * Default: `ro`
     */
    public val permission: aws.sdk.kotlin.services.greengrassv2.model.LambdaFilesystemPermission? = builder.permission
    /**
     * The path to the physical volume in the file system.
     */
    public val sourcePath: kotlin.String = requireNotNull(builder.sourcePath) { "A non-null value must be provided for sourcePath" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.LambdaVolumeMount = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaVolumeMount(")
        append("addGroupOwner=$addGroupOwner,")
        append("destinationPath=$destinationPath,")
        append("permission=$permission,")
        append("sourcePath=$sourcePath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addGroupOwner?.hashCode() ?: 0
        result = 31 * result + (destinationPath.hashCode())
        result = 31 * result + (permission?.hashCode() ?: 0)
        result = 31 * result + (sourcePath.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaVolumeMount

        if (addGroupOwner != other.addGroupOwner) return false
        if (destinationPath != other.destinationPath) return false
        if (permission != other.permission) return false
        if (sourcePath != other.sourcePath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.LambdaVolumeMount = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether or not to add the IoT Greengrass user group as an owner of the volume.
         *
         * Default: `false`
         */
        public var addGroupOwner: kotlin.Boolean? = null
        /**
         * The path to the logical volume in the file system.
         */
        public var destinationPath: kotlin.String? = null
        /**
         * The permission to access the volume: read/only (`ro`) or read/write (`rw`).
         *
         * Default: `ro`
         */
        public var permission: aws.sdk.kotlin.services.greengrassv2.model.LambdaFilesystemPermission? = null
        /**
         * The path to the physical volume in the file system.
         */
        public var sourcePath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.LambdaVolumeMount) : this() {
            this.addGroupOwner = x.addGroupOwner
            this.destinationPath = x.destinationPath
            this.permission = x.permission
            this.sourcePath = x.sourcePath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.LambdaVolumeMount = LambdaVolumeMount(this)

        internal fun correctErrors(): Builder {
            if (destinationPath == null) destinationPath = ""
            if (sourcePath == null) sourcePath = ""
            return this
        }
    }
}
