// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a container in which Lambda functions run on Greengrass core devices.
 */
public class LambdaContainerParams private constructor(builder: Builder) {
    /**
     * The list of system devices that the container can access.
     */
    public val devices: List<LambdaDeviceMount>? = builder.devices
    /**
     * The memory size of the container, expressed in kilobytes.
     *
     * Default: `16384` (16 MB)
     */
    public val memorySizeInKb: kotlin.Int? = builder.memorySizeInKb
    /**
     * Whether or not the container can read information from the device's `/sys` folder.
     *
     * Default: `false`
     */
    public val mountRoSysfs: kotlin.Boolean? = builder.mountRoSysfs
    /**
     * The list of volumes that the container can access.
     */
    public val volumes: List<LambdaVolumeMount>? = builder.volumes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.LambdaContainerParams = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaContainerParams(")
        append("devices=$devices,")
        append("memorySizeInKb=$memorySizeInKb,")
        append("mountRoSysfs=$mountRoSysfs,")
        append("volumes=$volumes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = devices?.hashCode() ?: 0
        result = 31 * result + (memorySizeInKb ?: 0)
        result = 31 * result + (mountRoSysfs?.hashCode() ?: 0)
        result = 31 * result + (volumes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaContainerParams

        if (devices != other.devices) return false
        if (memorySizeInKb != other.memorySizeInKb) return false
        if (mountRoSysfs != other.mountRoSysfs) return false
        if (volumes != other.volumes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.LambdaContainerParams = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of system devices that the container can access.
         */
        public var devices: List<LambdaDeviceMount>? = null
        /**
         * The memory size of the container, expressed in kilobytes.
         *
         * Default: `16384` (16 MB)
         */
        public var memorySizeInKb: kotlin.Int? = null
        /**
         * Whether or not the container can read information from the device's `/sys` folder.
         *
         * Default: `false`
         */
        public var mountRoSysfs: kotlin.Boolean? = null
        /**
         * The list of volumes that the container can access.
         */
        public var volumes: List<LambdaVolumeMount>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.LambdaContainerParams) : this() {
            this.devices = x.devices
            this.memorySizeInKb = x.memorySizeInKb
            this.mountRoSysfs = x.mountRoSysfs
            this.volumes = x.volumes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.LambdaContainerParams = LambdaContainerParams(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
