// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a deployment job that IoT Greengrass sends to a Greengrass core device.
 */
public class EffectiveDeployment private constructor(builder: Builder) {
    /**
     * The status of the deployment job on the Greengrass core device.
     * + `IN_PROGRESS` – The deployment job is running.
     * + `QUEUED` – The deployment job is in the job queue and waiting to run.
     * + `FAILED` – The deployment failed. For more information, see the `statusDetails` field.
     * + `COMPLETED` – The deployment to an IoT thing was completed successfully.
     * + `TIMED_OUT` – The deployment didn't complete in the allotted time.
     * + `CANCELED` – The deployment was canceled by the user.
     * + `REJECTED` – The deployment was rejected. For more information, see the `statusDetails` field.
     * + `SUCCEEDED` – The deployment to an IoT thing group was completed successfully.
     */
    public val coreDeviceExecutionStatus: aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeploymentExecutionStatus = requireNotNull(builder.coreDeviceExecutionStatus) { "A non-null value must be provided for coreDeviceExecutionStatus" }
    /**
     * The time at which the deployment was created, expressed in ISO 8601 format.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTimestamp) { "A non-null value must be provided for creationTimestamp" }
    /**
     * The ID of the deployment.
     */
    public val deploymentId: kotlin.String = requireNotNull(builder.deploymentId) { "A non-null value must be provided for deploymentId" }
    /**
     * The name of the deployment.
     */
    public val deploymentName: kotlin.String = requireNotNull(builder.deploymentName) { "A non-null value must be provided for deploymentName" }
    /**
     * The description of the deployment job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IoT job that applies the deployment to target devices.
     */
    public val iotJobArn: kotlin.String? = builder.iotJobArn
    /**
     * The ID of the IoT job that applies the deployment to target devices.
     */
    public val iotJobId: kotlin.String? = builder.iotJobId
    /**
     * The time at which the deployment job was last modified, expressed in ISO 8601 format.
     */
    public val modifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedTimestamp) { "A non-null value must be provided for modifiedTimestamp" }
    /**
     * The reason code for the update, if the job was updated.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The status details that explain why a deployment has an error. This response will be null if the deployment is in a success state.
     */
    public val statusDetails: aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeploymentStatusDetails? = builder.statusDetails
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the target IoT thing or thing group.
     */
    public val targetArn: kotlin.String = requireNotNull(builder.targetArn) { "A non-null value must be provided for targetArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeployment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EffectiveDeployment(")
        append("coreDeviceExecutionStatus=$coreDeviceExecutionStatus,")
        append("creationTimestamp=$creationTimestamp,")
        append("deploymentId=$deploymentId,")
        append("deploymentName=$deploymentName,")
        append("description=$description,")
        append("iotJobArn=$iotJobArn,")
        append("iotJobId=$iotJobId,")
        append("modifiedTimestamp=$modifiedTimestamp,")
        append("reason=$reason,")
        append("statusDetails=$statusDetails,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = coreDeviceExecutionStatus.hashCode()
        result = 31 * result + (creationTimestamp.hashCode())
        result = 31 * result + (deploymentId.hashCode())
        result = 31 * result + (deploymentName.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (iotJobArn?.hashCode() ?: 0)
        result = 31 * result + (iotJobId?.hashCode() ?: 0)
        result = 31 * result + (modifiedTimestamp.hashCode())
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (targetArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EffectiveDeployment

        if (coreDeviceExecutionStatus != other.coreDeviceExecutionStatus) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (deploymentId != other.deploymentId) return false
        if (deploymentName != other.deploymentName) return false
        if (description != other.description) return false
        if (iotJobArn != other.iotJobArn) return false
        if (iotJobId != other.iotJobId) return false
        if (modifiedTimestamp != other.modifiedTimestamp) return false
        if (reason != other.reason) return false
        if (statusDetails != other.statusDetails) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeployment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The status of the deployment job on the Greengrass core device.
         * + `IN_PROGRESS` – The deployment job is running.
         * + `QUEUED` – The deployment job is in the job queue and waiting to run.
         * + `FAILED` – The deployment failed. For more information, see the `statusDetails` field.
         * + `COMPLETED` – The deployment to an IoT thing was completed successfully.
         * + `TIMED_OUT` – The deployment didn't complete in the allotted time.
         * + `CANCELED` – The deployment was canceled by the user.
         * + `REJECTED` – The deployment was rejected. For more information, see the `statusDetails` field.
         * + `SUCCEEDED` – The deployment to an IoT thing group was completed successfully.
         */
        public var coreDeviceExecutionStatus: aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeploymentExecutionStatus? = null
        /**
         * The time at which the deployment was created, expressed in ISO 8601 format.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the deployment.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * The name of the deployment.
         */
        public var deploymentName: kotlin.String? = null
        /**
         * The description of the deployment job.
         */
        public var description: kotlin.String? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IoT job that applies the deployment to target devices.
         */
        public var iotJobArn: kotlin.String? = null
        /**
         * The ID of the IoT job that applies the deployment to target devices.
         */
        public var iotJobId: kotlin.String? = null
        /**
         * The time at which the deployment job was last modified, expressed in ISO 8601 format.
         */
        public var modifiedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The reason code for the update, if the job was updated.
         */
        public var reason: kotlin.String? = null
        /**
         * The status details that explain why a deployment has an error. This response will be null if the deployment is in a success state.
         */
        public var statusDetails: aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeploymentStatusDetails? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the target IoT thing or thing group.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeployment) : this() {
            this.coreDeviceExecutionStatus = x.coreDeviceExecutionStatus
            this.creationTimestamp = x.creationTimestamp
            this.deploymentId = x.deploymentId
            this.deploymentName = x.deploymentName
            this.description = x.description
            this.iotJobArn = x.iotJobArn
            this.iotJobId = x.iotJobId
            this.modifiedTimestamp = x.modifiedTimestamp
            this.reason = x.reason
            this.statusDetails = x.statusDetails
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeployment = EffectiveDeployment(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeploymentStatusDetails] inside the given [block]
         */
        public fun statusDetails(block: aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeploymentStatusDetails.Builder.() -> kotlin.Unit) {
            this.statusDetails = aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeploymentStatusDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (coreDeviceExecutionStatus == null) coreDeviceExecutionStatus = EffectiveDeploymentExecutionStatus.SdkUnknown("no value provided")
            if (creationTimestamp == null) creationTimestamp = Instant.fromEpochSeconds(0)
            if (deploymentId == null) deploymentId = ""
            if (deploymentName == null) deploymentName = ""
            if (modifiedTimestamp == null) modifiedTimestamp = Instant.fromEpochSeconds(0)
            if (targetArn == null) targetArn = ""
            return this
        }
    }
}
