// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about how long a component on a core device can validate its configuration updates before it times out. Components can use the [SubscribeToValidateConfigurationUpdates](https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetovalidateconfigurationupdates) IPC operation to receive notifications when a deployment specifies a configuration update. Then, components can respond with the [SendConfigurationValidityReport](https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-sendconfigurationvalidityreport) IPC operation. For more information, see [Create deployments](https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html) in the *IoT Greengrass V2 Developer Guide*.
 */
public class DeploymentConfigurationValidationPolicy private constructor(builder: Builder) {
    /**
     * The amount of time in seconds that a component can validate its configuration updates. If the validation time exceeds this timeout, then the deployment proceeds for the device.
     *
     * Default: `30`
     */
    public val timeoutInSeconds: kotlin.Int? = builder.timeoutInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.DeploymentConfigurationValidationPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentConfigurationValidationPolicy(")
        append("timeoutInSeconds=$timeoutInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = timeoutInSeconds ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentConfigurationValidationPolicy

        if (timeoutInSeconds != other.timeoutInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.DeploymentConfigurationValidationPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of time in seconds that a component can validate its configuration updates. If the validation time exceeds this timeout, then the deployment proceeds for the device.
         *
         * Default: `30`
         */
        public var timeoutInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.DeploymentConfigurationValidationPolicy) : this() {
            this.timeoutInSeconds = x.timeoutInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.DeploymentConfigurationValidationPolicy = DeploymentConfigurationValidationPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
