// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



public class CreateComponentVersionRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The recipe to use to create the component. The recipe defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform compatibility.
     *
     * You must specify either `inlineRecipe` or `lambdaFunction`.
     */
    public val inlineRecipe: kotlin.ByteArray? = builder.inlineRecipe
    /**
     * The parameters to create a component from a Lambda function.
     *
     * You must specify either `inlineRecipe` or `lambdaFunction`.
     */
    public val lambdaFunction: aws.sdk.kotlin.services.greengrassv2.model.LambdaFunctionRecipeSource? = builder.lambdaFunction
    /**
     * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.CreateComponentVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateComponentVersionRequest(")
        append("clientToken=$clientToken,")
        append("inlineRecipe=$inlineRecipe,")
        append("lambdaFunction=$lambdaFunction,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (inlineRecipe?.contentHashCode() ?: 0)
        result = 31 * result + (lambdaFunction?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateComponentVersionRequest

        if (clientToken != other.clientToken) return false
        if (inlineRecipe != null) {
            if (other.inlineRecipe == null) return false
            if (!inlineRecipe.contentEquals(other.inlineRecipe)) return false
        } else if (other.inlineRecipe != null) return false
        if (lambdaFunction != other.lambdaFunction) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.CreateComponentVersionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The recipe to use to create the component. The recipe defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform compatibility.
         *
         * You must specify either `inlineRecipe` or `lambdaFunction`.
         */
        public var inlineRecipe: kotlin.ByteArray? = null
        /**
         * The parameters to create a component from a Lambda function.
         *
         * You must specify either `inlineRecipe` or `lambdaFunction`.
         */
        public var lambdaFunction: aws.sdk.kotlin.services.greengrassv2.model.LambdaFunctionRecipeSource? = null
        /**
         * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.CreateComponentVersionRequest) : this() {
            this.clientToken = x.clientToken
            this.inlineRecipe = x.inlineRecipe
            this.lambdaFunction = x.lambdaFunction
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.CreateComponentVersionRequest = CreateComponentVersionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.LambdaFunctionRecipeSource] inside the given [block]
         */
        public fun lambdaFunction(block: aws.sdk.kotlin.services.greengrassv2.model.LambdaFunctionRecipeSource.Builder.() -> kotlin.Unit) {
            this.lambdaFunction = aws.sdk.kotlin.services.greengrassv2.model.LambdaFunctionRecipeSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
