// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a component to deploy.
 */
public class ComponentDeploymentSpecification private constructor(builder: Builder) {
    /**
     * The version of the component.
     */
    public val componentVersion: kotlin.String? = builder.componentVersion
    /**
     * The configuration updates to deploy for the component. You can define *reset* updates and *merge* updates. A reset updates the keys that you specify to the default configuration for the component. A merge updates the core device's component configuration with the keys and values that you specify. The IoT Greengrass Core software applies reset updates before it applies merge updates. For more information, see [Update component configurations](https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html) in the *IoT Greengrass V2 Developer Guide*.
     */
    public val configurationUpdate: aws.sdk.kotlin.services.greengrassv2.model.ComponentConfigurationUpdate? = builder.configurationUpdate
    /**
     * The system user and group that the IoT Greengrass Core software uses to run component processes on the core device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group that you configure for the core device. For more information, see [Configure the user and group that run components](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user) in the *IoT Greengrass V2 Developer Guide*.
     */
    public val runWith: aws.sdk.kotlin.services.greengrassv2.model.ComponentRunWith? = builder.runWith

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.ComponentDeploymentSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentDeploymentSpecification(")
        append("componentVersion=$componentVersion,")
        append("configurationUpdate=$configurationUpdate,")
        append("runWith=$runWith")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentVersion?.hashCode() ?: 0
        result = 31 * result + (configurationUpdate?.hashCode() ?: 0)
        result = 31 * result + (runWith?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComponentDeploymentSpecification

        if (componentVersion != other.componentVersion) return false
        if (configurationUpdate != other.configurationUpdate) return false
        if (runWith != other.runWith) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.ComponentDeploymentSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The version of the component.
         */
        public var componentVersion: kotlin.String? = null
        /**
         * The configuration updates to deploy for the component. You can define *reset* updates and *merge* updates. A reset updates the keys that you specify to the default configuration for the component. A merge updates the core device's component configuration with the keys and values that you specify. The IoT Greengrass Core software applies reset updates before it applies merge updates. For more information, see [Update component configurations](https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html) in the *IoT Greengrass V2 Developer Guide*.
         */
        public var configurationUpdate: aws.sdk.kotlin.services.greengrassv2.model.ComponentConfigurationUpdate? = null
        /**
         * The system user and group that the IoT Greengrass Core software uses to run component processes on the core device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group that you configure for the core device. For more information, see [Configure the user and group that run components](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user) in the *IoT Greengrass V2 Developer Guide*.
         */
        public var runWith: aws.sdk.kotlin.services.greengrassv2.model.ComponentRunWith? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.ComponentDeploymentSpecification) : this() {
            this.componentVersion = x.componentVersion
            this.configurationUpdate = x.configurationUpdate
            this.runWith = x.runWith
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.ComponentDeploymentSpecification = ComponentDeploymentSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.ComponentConfigurationUpdate] inside the given [block]
         */
        public fun configurationUpdate(block: aws.sdk.kotlin.services.greengrassv2.model.ComponentConfigurationUpdate.Builder.() -> kotlin.Unit) {
            this.configurationUpdate = aws.sdk.kotlin.services.greengrassv2.model.ComponentConfigurationUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.ComponentRunWith] inside the given [block]
         */
        public fun runWith(block: aws.sdk.kotlin.services.greengrassv2.model.ComponentRunWith.Builder.() -> kotlin.Unit) {
            this.runWith = aws.sdk.kotlin.services.greengrassv2.model.ComponentRunWith.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
