// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a component dependency for a Lambda function component.
 */
public class ComponentDependencyRequirement private constructor(builder: Builder) {
    /**
     * The type of this dependency. Choose from the following options:
     * + `SOFT` – The component doesn't restart if the dependency changes state.
     * + `HARD` – The component restarts if the dependency changes state.
     *
     * Default: `HARD`
     */
    public val dependencyType: aws.sdk.kotlin.services.greengrassv2.model.ComponentDependencyType? = builder.dependencyType
    /**
     * The component version requirement for the component dependency.
     *
     * IoT Greengrass V2 uses semantic version constraints. For more information, see [Semantic Versioning](https://semver.org/).
     */
    public val versionRequirement: kotlin.String? = builder.versionRequirement

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.ComponentDependencyRequirement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentDependencyRequirement(")
        append("dependencyType=$dependencyType,")
        append("versionRequirement=$versionRequirement")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dependencyType?.hashCode() ?: 0
        result = 31 * result + (versionRequirement?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComponentDependencyRequirement

        if (dependencyType != other.dependencyType) return false
        if (versionRequirement != other.versionRequirement) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.ComponentDependencyRequirement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of this dependency. Choose from the following options:
         * + `SOFT` – The component doesn't restart if the dependency changes state.
         * + `HARD` – The component restarts if the dependency changes state.
         *
         * Default: `HARD`
         */
        public var dependencyType: aws.sdk.kotlin.services.greengrassv2.model.ComponentDependencyType? = null
        /**
         * The component version requirement for the component dependency.
         *
         * IoT Greengrass V2 uses semantic version constraints. For more information, see [Semantic Versioning](https://semver.org/).
         */
        public var versionRequirement: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.ComponentDependencyRequirement) : this() {
            this.dependencyType = x.dependencyType
            this.versionRequirement = x.versionRequirement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.ComponentDependencyRequirement = ComponentDependencyRequirement(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
