// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



public class CreateDeploymentRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The components to deploy. This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.
     */
    public val components: Map<String, ComponentDeploymentSpecification>? = builder.components
    /**
     * The name of the deployment.
     */
    public val deploymentName: kotlin.String? = builder.deploymentName
    /**
     * The deployment policies for the deployment. These policies define how the deployment updates components and handles failure.
     */
    public val deploymentPolicies: aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies? = builder.deploymentPolicies
    /**
     * The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.
     */
    public val iotJobConfiguration: aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration? = builder.iotJobConfiguration
    /**
     * The parent deployment's target [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) within a subdeployment.
     */
    public val parentTargetArn: kotlin.String? = builder.parentTargetArn
    /**
     * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the target IoT thing or thing group. When creating a subdeployment, the targetARN can only be a thing group.
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.CreateDeploymentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentRequest(")
        append("clientToken=$clientToken,")
        append("components=$components,")
        append("deploymentName=$deploymentName,")
        append("deploymentPolicies=$deploymentPolicies,")
        append("iotJobConfiguration=$iotJobConfiguration,")
        append("parentTargetArn=$parentTargetArn,")
        append("tags=$tags,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (components?.hashCode() ?: 0)
        result = 31 * result + (deploymentName?.hashCode() ?: 0)
        result = 31 * result + (deploymentPolicies?.hashCode() ?: 0)
        result = 31 * result + (iotJobConfiguration?.hashCode() ?: 0)
        result = 31 * result + (parentTargetArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeploymentRequest

        if (clientToken != other.clientToken) return false
        if (components != other.components) return false
        if (deploymentName != other.deploymentName) return false
        if (deploymentPolicies != other.deploymentPolicies) return false
        if (iotJobConfiguration != other.iotJobConfiguration) return false
        if (parentTargetArn != other.parentTargetArn) return false
        if (tags != other.tags) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.CreateDeploymentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The components to deploy. This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.
         */
        public var components: Map<String, ComponentDeploymentSpecification>? = null
        /**
         * The name of the deployment.
         */
        public var deploymentName: kotlin.String? = null
        /**
         * The deployment policies for the deployment. These policies define how the deployment updates components and handles failure.
         */
        public var deploymentPolicies: aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies? = null
        /**
         * The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.
         */
        public var iotJobConfiguration: aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration? = null
        /**
         * The parent deployment's target [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) within a subdeployment.
         */
        public var parentTargetArn: kotlin.String? = null
        /**
         * A list of key-value pairs that contain metadata for the resource. For more information, see [Tag your resources](https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html) in the *IoT Greengrass V2 Developer Guide*.
         */
        public var tags: Map<String, String>? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the target IoT thing or thing group. When creating a subdeployment, the targetARN can only be a thing group.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.CreateDeploymentRequest) : this() {
            this.clientToken = x.clientToken
            this.components = x.components
            this.deploymentName = x.deploymentName
            this.deploymentPolicies = x.deploymentPolicies
            this.iotJobConfiguration = x.iotJobConfiguration
            this.parentTargetArn = x.parentTargetArn
            this.tags = x.tags
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.CreateDeploymentRequest = CreateDeploymentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies] inside the given [block]
         */
        public fun deploymentPolicies(block: aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies.Builder.() -> kotlin.Unit) {
            this.deploymentPolicies = aws.sdk.kotlin.services.greengrassv2.model.DeploymentPolicies.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration] inside the given [block]
         */
        public fun iotJobConfiguration(block: aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration.Builder.() -> kotlin.Unit) {
            this.iotJobConfiguration = aws.sdk.kotlin.services.greengrassv2.model.DeploymentIotJobConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
