// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about an endpoint and port where client devices can connect to an MQTT broker on a Greengrass core device.
 */
public class ConnectivityInfo private constructor(builder: Builder) {
    /**
     * The IP address or DNS address where client devices can connect to an MQTT broker on the Greengrass core device.
     */
    public val hostAddress: kotlin.String? = builder.hostAddress
    /**
     * An ID for the connectivity information.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Additional metadata to provide to client devices that connect to this core device.
     */
    public val metadata: kotlin.String? = builder.metadata
    /**
     * The port where the MQTT broker operates on the core device. This port is typically 8883, which is the default port for the MQTT broker component that runs on core devices.
     */
    public val portNumber: kotlin.Int = builder.portNumber

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.ConnectivityInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectivityInfo(")
        append("hostAddress=$hostAddress,")
        append("id=$id,")
        append("metadata=$metadata,")
        append("portNumber=$portNumber")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostAddress?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (portNumber)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectivityInfo

        if (hostAddress != other.hostAddress) return false
        if (id != other.id) return false
        if (metadata != other.metadata) return false
        if (portNumber != other.portNumber) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.ConnectivityInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IP address or DNS address where client devices can connect to an MQTT broker on the Greengrass core device.
         */
        public var hostAddress: kotlin.String? = null
        /**
         * An ID for the connectivity information.
         */
        public var id: kotlin.String? = null
        /**
         * Additional metadata to provide to client devices that connect to this core device.
         */
        public var metadata: kotlin.String? = null
        /**
         * The port where the MQTT broker operates on the core device. This port is typically 8883, which is the default port for the MQTT broker component that runs on core devices.
         */
        public var portNumber: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.ConnectivityInfo) : this() {
            this.hostAddress = x.hostAddress
            this.id = x.id
            this.metadata = x.metadata
            this.portNumber = x.portNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.ConnectivityInfo = ConnectivityInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
