// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the latest version of a component.
 */
public class ComponentLatestVersion private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the component version.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The version of the component.
     */
    public val componentVersion: kotlin.String? = builder.componentVersion
    /**
     * The time at which the component was created, expressed in ISO 8601 format.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The description of the component version.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The platforms that the component version supports.
     */
    public val platforms: List<ComponentPlatform>? = builder.platforms
    /**
     * The publisher of the component version.
     */
    public val publisher: kotlin.String? = builder.publisher

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.ComponentLatestVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentLatestVersion(")
        append("arn=$arn,")
        append("componentVersion=$componentVersion,")
        append("creationTimestamp=$creationTimestamp,")
        append("description=$description,")
        append("platforms=$platforms,")
        append("publisher=$publisher")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (platforms?.hashCode() ?: 0)
        result = 31 * result + (publisher?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComponentLatestVersion

        if (arn != other.arn) return false
        if (componentVersion != other.componentVersion) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (description != other.description) return false
        if (platforms != other.platforms) return false
        if (publisher != other.publisher) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.ComponentLatestVersion = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the component version.
         */
        public var arn: kotlin.String? = null
        /**
         * The version of the component.
         */
        public var componentVersion: kotlin.String? = null
        /**
         * The time at which the component was created, expressed in ISO 8601 format.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the component version.
         */
        public var description: kotlin.String? = null
        /**
         * The platforms that the component version supports.
         */
        public var platforms: List<ComponentPlatform>? = null
        /**
         * The publisher of the component version.
         */
        public var publisher: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.ComponentLatestVersion) : this() {
            this.arn = x.arn
            this.componentVersion = x.componentVersion
            this.creationTimestamp = x.creationTimestamp
            this.description = x.description
            this.platforms = x.platforms
            this.publisher = x.publisher
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.ComponentLatestVersion = ComponentLatestVersion(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
