// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains the status of a component version in the IoT Greengrass service.
 */
public class CloudComponentStatus private constructor(builder: Builder) {
    /**
     * The state of the component version.
     */
    public val componentState: aws.sdk.kotlin.services.greengrassv2.model.CloudComponentState? = builder.componentState
    /**
     * A dictionary of errors that communicate why the component version is in an error state. For example, if IoT Greengrass can't access an artifact for the component version, then `errors` contains the artifact's URI as a key, and the error message as the value for that key.
     */
    public val errors: Map<String, String>? = builder.errors
    /**
     * A message that communicates details, such as errors, about the status of the component version.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The vendor guidance state for the component version. This state indicates whether the component version has any issues that you should consider before you deploy it. The vendor guidance state can be:
     * + `ACTIVE` – This component version is available and recommended for use.
     * + `DISCONTINUED` – This component version has been discontinued by its publisher. You can deploy this component version, but we recommend that you use a different version of this component.
     * + `DELETED` – This component version has been deleted by its publisher, so you can't deploy it. If you have any existing deployments that specify this component version, those deployments will fail.
     */
    public val vendorGuidance: aws.sdk.kotlin.services.greengrassv2.model.VendorGuidance? = builder.vendorGuidance
    /**
     * A message that communicates details about the vendor guidance state of the component version. This message communicates why a component version is discontinued or deleted.
     */
    public val vendorGuidanceMessage: kotlin.String? = builder.vendorGuidanceMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudComponentStatus(")
        append("componentState=$componentState,")
        append("errors=$errors,")
        append("message=$message,")
        append("vendorGuidance=$vendorGuidance,")
        append("vendorGuidanceMessage=$vendorGuidanceMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentState?.hashCode() ?: 0
        result = 31 * result + (errors?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (vendorGuidance?.hashCode() ?: 0)
        result = 31 * result + (vendorGuidanceMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudComponentStatus

        if (componentState != other.componentState) return false
        if (errors != other.errors) return false
        if (message != other.message) return false
        if (vendorGuidance != other.vendorGuidance) return false
        if (vendorGuidanceMessage != other.vendorGuidanceMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The state of the component version.
         */
        public var componentState: aws.sdk.kotlin.services.greengrassv2.model.CloudComponentState? = null
        /**
         * A dictionary of errors that communicate why the component version is in an error state. For example, if IoT Greengrass can't access an artifact for the component version, then `errors` contains the artifact's URI as a key, and the error message as the value for that key.
         */
        public var errors: Map<String, String>? = null
        /**
         * A message that communicates details, such as errors, about the status of the component version.
         */
        public var message: kotlin.String? = null
        /**
         * The vendor guidance state for the component version. This state indicates whether the component version has any issues that you should consider before you deploy it. The vendor guidance state can be:
         * + `ACTIVE` – This component version is available and recommended for use.
         * + `DISCONTINUED` – This component version has been discontinued by its publisher. You can deploy this component version, but we recommend that you use a different version of this component.
         * + `DELETED` – This component version has been deleted by its publisher, so you can't deploy it. If you have any existing deployments that specify this component version, those deployments will fail.
         */
        public var vendorGuidance: aws.sdk.kotlin.services.greengrassv2.model.VendorGuidance? = null
        /**
         * A message that communicates details about the vendor guidance state of the component version. This message communicates why a component version is discontinued or deleted.
         */
        public var vendorGuidanceMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus) : this() {
            this.componentState = x.componentState
            this.errors = x.errors
            this.message = x.message
            this.vendorGuidance = x.vendorGuidance
            this.vendorGuidanceMessage = x.vendorGuidanceMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.CloudComponentStatus = CloudComponentStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
