// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.transform

import aws.sdk.kotlin.services.greengrassv2.model.GetComponentResponse
import aws.sdk.kotlin.services.greengrassv2.model.GreengrassV2Exception
import aws.sdk.kotlin.services.greengrassv2.model.RecipeOutputFormat
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.decodeBase64Bytes
import kotlin.collections.mutableMapOf


internal class GetComponentOperationDeserializer: HttpDeserialize<GetComponentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetComponentResponse {
        if (!response.status.isSuccess()) {
            throwGetComponentError(context, response)
        }
        val builder = GetComponentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetComponentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetComponentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GreengrassV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GreengrassV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetComponentOperationBody(builder: GetComponentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RECIPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("recipe"))
    val RECIPEOUTPUTFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("recipeOutputFormat"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RECIPE_DESCRIPTOR)
        field(RECIPEOUTPUTFORMAT_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RECIPE_DESCRIPTOR.index -> builder.recipe = deserializeString().decodeBase64Bytes()
                RECIPEOUTPUTFORMAT_DESCRIPTOR.index -> builder.recipeOutputFormat = deserializeString().let { RecipeOutputFormat.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
