// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.paginators

import aws.sdk.kotlin.services.greengrassv2.GreengrassV2Client
import aws.sdk.kotlin.services.greengrassv2.model.AssociatedClientDevice
import aws.sdk.kotlin.services.greengrassv2.model.Component
import aws.sdk.kotlin.services.greengrassv2.model.ComponentVersionListItem
import aws.sdk.kotlin.services.greengrassv2.model.CoreDevice
import aws.sdk.kotlin.services.greengrassv2.model.Deployment
import aws.sdk.kotlin.services.greengrassv2.model.EffectiveDeployment
import aws.sdk.kotlin.services.greengrassv2.model.InstalledComponent
import aws.sdk.kotlin.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListComponentVersionsRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListComponentVersionsResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListComponentsRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListComponentsResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListCoreDevicesRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListCoreDevicesResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListDeploymentsRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListDeploymentsResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListEffectiveDeploymentsRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListEffectiveDeploymentsResponse
import aws.sdk.kotlin.services.greengrassv2.model.ListInstalledComponentsRequest
import aws.sdk.kotlin.services.greengrassv2.model.ListInstalledComponentsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListClientDevicesAssociatedWithCoreDeviceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClientDevicesAssociatedWithCoreDeviceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClientDevicesAssociatedWithCoreDeviceResponse]
 */
public fun GreengrassV2Client.listClientDevicesAssociatedWithCoreDevicePaginated(initialRequest: ListClientDevicesAssociatedWithCoreDeviceRequest): Flow<ListClientDevicesAssociatedWithCoreDeviceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClientDevicesAssociatedWithCoreDevicePaginated.listClientDevicesAssociatedWithCoreDevice(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClientDevicesAssociatedWithCoreDeviceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClientDevicesAssociatedWithCoreDeviceResponse]
 */
public fun GreengrassV2Client.listClientDevicesAssociatedWithCoreDevicePaginated(block: ListClientDevicesAssociatedWithCoreDeviceRequest.Builder.() -> Unit): Flow<ListClientDevicesAssociatedWithCoreDeviceResponse> =
    listClientDevicesAssociatedWithCoreDevicePaginated(ListClientDevicesAssociatedWithCoreDeviceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClientDevicesAssociatedWithCoreDevicePaginated]
 * to access the nested member [AssociatedClientDevice]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AssociatedClientDevice]
 */
@JvmName("listClientDevicesAssociatedWithCoreDeviceResponseAssociatedClientDevice")
public fun Flow<ListClientDevicesAssociatedWithCoreDeviceResponse>.associatedClientDevices(): Flow<AssociatedClientDevice> =
    transform() { response ->
        response.associatedClientDevices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListComponentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentsResponse]
 */
public fun GreengrassV2Client.listComponentsPaginated(initialRequest: ListComponentsRequest): Flow<ListComponentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listComponentsPaginated.listComponents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentsResponse]
 */
public fun GreengrassV2Client.listComponentsPaginated(block: ListComponentsRequest.Builder.() -> Unit): Flow<ListComponentsResponse> =
    listComponentsPaginated(ListComponentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listComponentsPaginated]
 * to access the nested member [Component]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Component]
 */
@JvmName("listComponentsResponseComponent")
public fun Flow<ListComponentsResponse>.components(): Flow<Component> =
    transform() { response ->
        response.components?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListComponentVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListComponentVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentVersionsResponse]
 */
public fun GreengrassV2Client.listComponentVersionsPaginated(initialRequest: ListComponentVersionsRequest): Flow<ListComponentVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listComponentVersionsPaginated.listComponentVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListComponentVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentVersionsResponse]
 */
public fun GreengrassV2Client.listComponentVersionsPaginated(block: ListComponentVersionsRequest.Builder.() -> Unit): Flow<ListComponentVersionsResponse> =
    listComponentVersionsPaginated(ListComponentVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listComponentVersionsPaginated]
 * to access the nested member [ComponentVersionListItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ComponentVersionListItem]
 */
@JvmName("listComponentVersionsResponseComponentVersionListItem")
public fun Flow<ListComponentVersionsResponse>.componentVersions(): Flow<ComponentVersionListItem> =
    transform() { response ->
        response.componentVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCoreDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCoreDevicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoreDevicesResponse]
 */
public fun GreengrassV2Client.listCoreDevicesPaginated(initialRequest: ListCoreDevicesRequest): Flow<ListCoreDevicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCoreDevicesPaginated.listCoreDevices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCoreDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoreDevicesResponse]
 */
public fun GreengrassV2Client.listCoreDevicesPaginated(block: ListCoreDevicesRequest.Builder.() -> Unit): Flow<ListCoreDevicesResponse> =
    listCoreDevicesPaginated(ListCoreDevicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCoreDevicesPaginated]
 * to access the nested member [CoreDevice]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CoreDevice]
 */
@JvmName("listCoreDevicesResponseCoreDevice")
public fun Flow<ListCoreDevicesResponse>.coreDevices(): Flow<CoreDevice> =
    transform() { response ->
        response.coreDevices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeploymentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentsResponse]
 */
public fun GreengrassV2Client.listDeploymentsPaginated(initialRequest: ListDeploymentsRequest): Flow<ListDeploymentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeploymentsPaginated.listDeployments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentsResponse]
 */
public fun GreengrassV2Client.listDeploymentsPaginated(block: ListDeploymentsRequest.Builder.() -> Unit): Flow<ListDeploymentsResponse> =
    listDeploymentsPaginated(ListDeploymentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDeploymentsPaginated]
 * to access the nested member [Deployment]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Deployment]
 */
@JvmName("listDeploymentsResponseDeployment")
public fun Flow<ListDeploymentsResponse>.deployments(): Flow<Deployment> =
    transform() { response ->
        response.deployments?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEffectiveDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEffectiveDeploymentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEffectiveDeploymentsResponse]
 */
public fun GreengrassV2Client.listEffectiveDeploymentsPaginated(initialRequest: ListEffectiveDeploymentsRequest): Flow<ListEffectiveDeploymentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEffectiveDeploymentsPaginated.listEffectiveDeployments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEffectiveDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEffectiveDeploymentsResponse]
 */
public fun GreengrassV2Client.listEffectiveDeploymentsPaginated(block: ListEffectiveDeploymentsRequest.Builder.() -> Unit): Flow<ListEffectiveDeploymentsResponse> =
    listEffectiveDeploymentsPaginated(ListEffectiveDeploymentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEffectiveDeploymentsPaginated]
 * to access the nested member [EffectiveDeployment]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EffectiveDeployment]
 */
@JvmName("listEffectiveDeploymentsResponseEffectiveDeployment")
public fun Flow<ListEffectiveDeploymentsResponse>.effectiveDeployments(): Flow<EffectiveDeployment> =
    transform() { response ->
        response.effectiveDeployments?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInstalledComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstalledComponentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstalledComponentsResponse]
 */
public fun GreengrassV2Client.listInstalledComponentsPaginated(initialRequest: ListInstalledComponentsRequest): Flow<ListInstalledComponentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInstalledComponentsPaginated.listInstalledComponents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListInstalledComponentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstalledComponentsResponse]
 */
public fun GreengrassV2Client.listInstalledComponentsPaginated(block: ListInstalledComponentsRequest.Builder.() -> Unit): Flow<ListInstalledComponentsResponse> =
    listInstalledComponentsPaginated(ListInstalledComponentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInstalledComponentsPaginated]
 * to access the nested member [InstalledComponent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstalledComponent]
 */
@JvmName("listInstalledComponentsResponseInstalledComponent")
public fun Flow<ListInstalledComponentsResponse>.installedComponents(): Flow<InstalledComponent> =
    transform() { response ->
        response.installedComponents?.forEach {
            emit(it)
        }
    }
