// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about system resource limits that the IoT Greengrass Core software applies to a component's processes. For more information, see [Configure system resource limits for components](https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits).
 */
public class SystemResourceLimits private constructor(builder: Builder) {
    /**
     * The maximum amount of CPU time that a component's processes can use on the core device. A core device's total CPU time is equivalent to the device's number of CPU cores. For example, on a core device with 4 CPU cores, you can set this value to `2` to limit the component's processes to 50 percent usage of each CPU core. On a device with 1 CPU core, you can set this value to `0.25` to limit the component's processes to 25 percent usage of the CPU. If you set this value to a number greater than the number of CPU cores, the IoT Greengrass Core software doesn't limit the component's CPU usage.
     */
    public val cpus: kotlin.Double = builder.cpus
    /**
     * The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on the core device.
     */
    public val memory: kotlin.Long = builder.memory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.SystemResourceLimits = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SystemResourceLimits(")
        append("cpus=$cpus,")
        append("memory=$memory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cpus.hashCode()
        result = 31 * result + (memory.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SystemResourceLimits

        if (cpus != other.cpus) return false
        if (memory != other.memory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.SystemResourceLimits = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum amount of CPU time that a component's processes can use on the core device. A core device's total CPU time is equivalent to the device's number of CPU cores. For example, on a core device with 4 CPU cores, you can set this value to `2` to limit the component's processes to 50 percent usage of each CPU core. On a device with 1 CPU core, you can set this value to `0.25` to limit the component's processes to 25 percent usage of the CPU. If you set this value to a number greater than the number of CPU cores, the IoT Greengrass Core software doesn't limit the component's CPU usage.
         */
        public var cpus: kotlin.Double = 0.0
        /**
         * The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on the core device.
         */
        public var memory: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.SystemResourceLimits) : this() {
            this.cpus = x.cpus
            this.memory = x.memory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.SystemResourceLimits = SystemResourceLimits(this)
    }
}
