// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about an exponential rollout rate for a configuration deployment job.
 */
public class IoTJobExponentialRolloutRate private constructor(builder: Builder) {
    /**
     * The minimum number of devices that receive a pending job notification, per minute, when the job starts. This parameter defines the initial rollout rate of the job.
     */
    public val baseRatePerMinute: kotlin.Int = builder.baseRatePerMinute
    /**
     * The exponential factor to increase the rollout rate for the job.
     *
     * This parameter supports up to one digit after the decimal (for example, you can specify `1.5`, but not `1.55`).
     */
    public val incrementFactor: kotlin.Double = builder.incrementFactor
    /**
     * The criteria to increase the rollout rate for the job.
     */
    public val rateIncreaseCriteria: aws.sdk.kotlin.services.greengrassv2.model.IoTJobRateIncreaseCriteria? = builder.rateIncreaseCriteria

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.IoTJobExponentialRolloutRate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IoTJobExponentialRolloutRate(")
        append("baseRatePerMinute=$baseRatePerMinute,")
        append("incrementFactor=$incrementFactor,")
        append("rateIncreaseCriteria=$rateIncreaseCriteria")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseRatePerMinute
        result = 31 * result + (incrementFactor.hashCode())
        result = 31 * result + (rateIncreaseCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IoTJobExponentialRolloutRate

        if (baseRatePerMinute != other.baseRatePerMinute) return false
        if (incrementFactor != other.incrementFactor) return false
        if (rateIncreaseCriteria != other.rateIncreaseCriteria) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.IoTJobExponentialRolloutRate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The minimum number of devices that receive a pending job notification, per minute, when the job starts. This parameter defines the initial rollout rate of the job.
         */
        public var baseRatePerMinute: kotlin.Int = 0
        /**
         * The exponential factor to increase the rollout rate for the job.
         *
         * This parameter supports up to one digit after the decimal (for example, you can specify `1.5`, but not `1.55`).
         */
        public var incrementFactor: kotlin.Double = 0.0
        /**
         * The criteria to increase the rollout rate for the job.
         */
        public var rateIncreaseCriteria: aws.sdk.kotlin.services.greengrassv2.model.IoTJobRateIncreaseCriteria? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.IoTJobExponentialRolloutRate) : this() {
            this.baseRatePerMinute = x.baseRatePerMinute
            this.incrementFactor = x.incrementFactor
            this.rateIncreaseCriteria = x.rateIncreaseCriteria
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.IoTJobExponentialRolloutRate = IoTJobExponentialRolloutRate(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrassv2.model.IoTJobRateIncreaseCriteria] inside the given [block]
         */
        public fun rateIncreaseCriteria(block: aws.sdk.kotlin.services.greengrassv2.model.IoTJobRateIncreaseCriteria.Builder.() -> kotlin.Unit) {
            this.rateIncreaseCriteria = aws.sdk.kotlin.services.greengrassv2.model.IoTJobRateIncreaseCriteria.invoke(block)
        }
    }
}
