// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains criteria that define when and how to cancel a job.
 *
 * The deployment stops if the following conditions are true:
 * + The number of things that receive the deployment exceeds the `minNumberOfExecutedThings`.
 * + The percentage of failures with type `failureType` exceeds the `thresholdPercentage`.
 */
public class IoTJobAbortCriteria private constructor(builder: Builder) {
    /**
     * The action to perform when the criteria are met.
     */
    public val action: aws.sdk.kotlin.services.greengrassv2.model.IoTJobAbortAction? = builder.action
    /**
     * The type of job deployment failure that can cancel a job.
     */
    public val failureType: aws.sdk.kotlin.services.greengrassv2.model.IoTJobExecutionFailureType? = builder.failureType
    /**
     * The minimum number of things that receive the configuration before the job can cancel.
     */
    public val minNumberOfExecutedThings: kotlin.Int = builder.minNumberOfExecutedThings
    /**
     * The minimum percentage of `failureType` failures that occur before the job can cancel.
     *
     * This parameter supports up to two digits after the decimal (for example, you can specify `10.9` or `10.99`, but not `10.999`).
     */
    public val thresholdPercentage: kotlin.Double = builder.thresholdPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.IoTJobAbortCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IoTJobAbortCriteria(")
        append("action=$action,")
        append("failureType=$failureType,")
        append("minNumberOfExecutedThings=$minNumberOfExecutedThings,")
        append("thresholdPercentage=$thresholdPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (failureType?.hashCode() ?: 0)
        result = 31 * result + (minNumberOfExecutedThings)
        result = 31 * result + (thresholdPercentage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IoTJobAbortCriteria

        if (action != other.action) return false
        if (failureType != other.failureType) return false
        if (minNumberOfExecutedThings != other.minNumberOfExecutedThings) return false
        if (thresholdPercentage != other.thresholdPercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.IoTJobAbortCriteria = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action to perform when the criteria are met.
         */
        public var action: aws.sdk.kotlin.services.greengrassv2.model.IoTJobAbortAction? = null
        /**
         * The type of job deployment failure that can cancel a job.
         */
        public var failureType: aws.sdk.kotlin.services.greengrassv2.model.IoTJobExecutionFailureType? = null
        /**
         * The minimum number of things that receive the configuration before the job can cancel.
         */
        public var minNumberOfExecutedThings: kotlin.Int = 0
        /**
         * The minimum percentage of `failureType` failures that occur before the job can cancel.
         *
         * This parameter supports up to two digits after the decimal (for example, you can specify `10.9` or `10.99`, but not `10.999`).
         */
        public var thresholdPercentage: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.IoTJobAbortCriteria) : this() {
            this.action = x.action
            this.failureType = x.failureType
            this.minNumberOfExecutedThings = x.minNumberOfExecutedThings
            this.thresholdPercentage = x.thresholdPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.IoTJobAbortCriteria = IoTJobAbortCriteria(this)
    }
}
