// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a component on a Greengrass core device.
 */
public class InstalledComponent private constructor(builder: Builder) {
    /**
     * The name of the component.
     */
    public val componentName: kotlin.String? = builder.componentName
    /**
     * The version of the component.
     */
    public val componentVersion: kotlin.String? = builder.componentVersion
    /**
     * Whether or not the component is a root component.
     */
    public val isRoot: kotlin.Boolean = builder.isRoot
    /**
     * The most recent deployment source that brought the component to the Greengrass core device. For a thing group deployment or thing deployment, the source will be the The ID of the deployment. and for local deployments it will be `LOCAL`.
     *
     * Any deployment will attempt to reinstall currently broken components on the device, which will update the last installation source.
     */
    public val lastInstallationSource: kotlin.String? = builder.lastInstallationSource
    /**
     * The last time the Greengrass core device sent a message containing a component's state to the Amazon Web Services Cloud.
     *
     * A component does not need to see a state change for this field to update.
     */
    public val lastReportedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastReportedTimestamp
    /**
     * The status of how current the data is.
     *
     * This response is based off of component state changes. The status reflects component disruptions and deployments. If a component only sees a configuration update during a deployment, it might not undergo a state change and this status would not be updated.
     */
    public val lastStatusChangeTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastStatusChangeTimestamp
    /**
     * The lifecycle state of the component.
     */
    public val lifecycleState: aws.sdk.kotlin.services.greengrassv2.model.InstalledComponentLifecycleState? = builder.lifecycleState
    /**
     * A detailed response about the lifecycle state of the component that explains the reason why a component has an error or is broken.
     */
    public val lifecycleStateDetails: kotlin.String? = builder.lifecycleStateDetails
    /**
     * The status codes that indicate the reason for failure whenever the `lifecycleState` has an error or is in a broken state.
     *
     * Greengrass nucleus v2.8.0 or later is required to get an accurate `lifecycleStatusCodes` response. This response can be inaccurate in earlier Greengrass nucleus versions.
     */
    public val lifecycleStatusCodes: List<String>? = builder.lifecycleStatusCodes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.InstalledComponent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstalledComponent(")
        append("componentName=$componentName,")
        append("componentVersion=$componentVersion,")
        append("isRoot=$isRoot,")
        append("lastInstallationSource=$lastInstallationSource,")
        append("lastReportedTimestamp=$lastReportedTimestamp,")
        append("lastStatusChangeTimestamp=$lastStatusChangeTimestamp,")
        append("lifecycleState=$lifecycleState,")
        append("lifecycleStateDetails=$lifecycleStateDetails,")
        append("lifecycleStatusCodes=$lifecycleStatusCodes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentName?.hashCode() ?: 0
        result = 31 * result + (componentVersion?.hashCode() ?: 0)
        result = 31 * result + (isRoot.hashCode())
        result = 31 * result + (lastInstallationSource?.hashCode() ?: 0)
        result = 31 * result + (lastReportedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastStatusChangeTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lifecycleState?.hashCode() ?: 0)
        result = 31 * result + (lifecycleStateDetails?.hashCode() ?: 0)
        result = 31 * result + (lifecycleStatusCodes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstalledComponent

        if (componentName != other.componentName) return false
        if (componentVersion != other.componentVersion) return false
        if (isRoot != other.isRoot) return false
        if (lastInstallationSource != other.lastInstallationSource) return false
        if (lastReportedTimestamp != other.lastReportedTimestamp) return false
        if (lastStatusChangeTimestamp != other.lastStatusChangeTimestamp) return false
        if (lifecycleState != other.lifecycleState) return false
        if (lifecycleStateDetails != other.lifecycleStateDetails) return false
        if (lifecycleStatusCodes != other.lifecycleStatusCodes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.InstalledComponent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the component.
         */
        public var componentName: kotlin.String? = null
        /**
         * The version of the component.
         */
        public var componentVersion: kotlin.String? = null
        /**
         * Whether or not the component is a root component.
         */
        public var isRoot: kotlin.Boolean = false
        /**
         * The most recent deployment source that brought the component to the Greengrass core device. For a thing group deployment or thing deployment, the source will be the The ID of the deployment. and for local deployments it will be `LOCAL`.
         *
         * Any deployment will attempt to reinstall currently broken components on the device, which will update the last installation source.
         */
        public var lastInstallationSource: kotlin.String? = null
        /**
         * The last time the Greengrass core device sent a message containing a component's state to the Amazon Web Services Cloud.
         *
         * A component does not need to see a state change for this field to update.
         */
        public var lastReportedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of how current the data is.
         *
         * This response is based off of component state changes. The status reflects component disruptions and deployments. If a component only sees a configuration update during a deployment, it might not undergo a state change and this status would not be updated.
         */
        public var lastStatusChangeTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The lifecycle state of the component.
         */
        public var lifecycleState: aws.sdk.kotlin.services.greengrassv2.model.InstalledComponentLifecycleState? = null
        /**
         * A detailed response about the lifecycle state of the component that explains the reason why a component has an error or is broken.
         */
        public var lifecycleStateDetails: kotlin.String? = null
        /**
         * The status codes that indicate the reason for failure whenever the `lifecycleState` has an error or is in a broken state.
         *
         * Greengrass nucleus v2.8.0 or later is required to get an accurate `lifecycleStatusCodes` response. This response can be inaccurate in earlier Greengrass nucleus versions.
         */
        public var lifecycleStatusCodes: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.InstalledComponent) : this() {
            this.componentName = x.componentName
            this.componentVersion = x.componentVersion
            this.isRoot = x.isRoot
            this.lastInstallationSource = x.lastInstallationSource
            this.lastReportedTimestamp = x.lastReportedTimestamp
            this.lastStatusChangeTimestamp = x.lastStatusChangeTimestamp
            this.lifecycleState = x.lifecycleState
            this.lifecycleStateDetails = x.lifecycleStateDetails
            this.lifecycleStatusCodes = x.lifecycleStatusCodes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.InstalledComponent = InstalledComponent(this)
    }
}
