// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.model



/**
 * Contains information about a platform that a component supports.
 */
public class ComponentPlatform private constructor(builder: Builder) {
    /**
     * A dictionary of attributes for the platform. The IoT Greengrass Core software defines the `os` and `architecture` by default. You can specify additional platform attributes for a core device when you deploy the Greengrass nucleus component. For more information, see the [Greengrass nucleus component](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html) in the *IoT Greengrass V2 Developer Guide*.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The friendly name of the platform. This name helps you identify the platform.
     *
     * If you omit this parameter, IoT Greengrass creates a friendly name from the `os` and `architecture` of the platform.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrassv2.model.ComponentPlatform = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentPlatform(")
        append("attributes=$attributes,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComponentPlatform

        if (attributes != other.attributes) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrassv2.model.ComponentPlatform = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A dictionary of attributes for the platform. The IoT Greengrass Core software defines the `os` and `architecture` by default. You can specify additional platform attributes for a core device when you deploy the Greengrass nucleus component. For more information, see the [Greengrass nucleus component](https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html) in the *IoT Greengrass V2 Developer Guide*.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The friendly name of the platform. This name helps you identify the platform.
         *
         * If you omit this parameter, IoT Greengrass creates a friendly name from the `os` and `architecture` of the platform.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrassv2.model.ComponentPlatform) : this() {
            this.attributes = x.attributes
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrassv2.model.ComponentPlatform = ComponentPlatform(this)
    }
}
