// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrassv2.endpoints

import aws.sdk.kotlin.services.greengrassv2.endpoints.internal.partition
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.client.endpoints.SigningContext
import aws.smithy.kotlin.runtime.client.endpoints.SigningContextAttributeKey
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.util.attributesOf

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultEndpointProvider: EndpointProvider {
    public override suspend fun resolveEndpoint(params: EndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint),
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://greengrass-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS
                        ) {
                            if (
                                params.region == "us-gov-east-1"
                            ) {
                                return Endpoint(
                                    Url.parse("https://greengrass.us-gov-east-1.amazonaws.com"),
                                )
                            }
                            if (
                                params.region == "us-gov-west-1"
                            ) {
                                return Endpoint(
                                    Url.parse("https://greengrass.us-gov-west-1.amazonaws.com"),
                                )
                            }
                            return Endpoint(
                                Url.parse("https://greengrass-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://greengrass.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    if (
                        params.region == "dataplane-us-gov-east-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://greengrass-ats.iot.us-gov-east-1.amazonaws.com"),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    SigningContext.SigV4(
                                        signingName = "greengrass",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-gov-east-1",
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "dataplane-us-gov-west-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://greengrass-ats.iot.us-gov-west-1.amazonaws.com"),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    SigningContext.SigV4(
                                        signingName = "greengrass",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-gov-west-1",
                                    ),
                                )
                            },
                        )
                    }
                    return Endpoint(
                        Url.parse("https://greengrass.${params.region}.${partitionResult?.dnsSuffix}"),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
