// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.serde

import aws.sdk.kotlin.services.greengrass.model.CreateSubscriptionDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.Subscription
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateSubscriptionDefinitionVersionOperationSerializer: HttpSerializer.NonStreaming<CreateSubscriptionDefinitionVersionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateSubscriptionDefinitionVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.subscriptionDefinitionId) { "subscriptionDefinitionId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("greengrass"))
                add(PercentEncoding.Path.encode("definition"))
                add(PercentEncoding.Path.encode("subscriptions"))
                add(PercentEncoding.SmithyLabel.encode(input.subscriptionDefinitionId))
                add(PercentEncoding.Path.encode("versions"))
            }
        }

        builder.headers {
            if (input.amznClientToken != null) append("X-Amzn-Client-Token", input.amznClientToken)
        }

        val payload = serializeCreateSubscriptionDefinitionVersionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateSubscriptionDefinitionVersionOperationBody(context: ExecutionContext, input: CreateSubscriptionDefinitionVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val SUBSCRIPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Subscriptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SUBSCRIPTIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.subscriptions != null) {
            listField(SUBSCRIPTIONS_DESCRIPTOR) {
                for (el0 in input.subscriptions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSubscriptionDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
