// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.serde

import aws.sdk.kotlin.services.greengrass.model.CreateDeviceDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.Device
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateDeviceDefinitionVersionOperationSerializer: HttpSerializer.NonStreaming<CreateDeviceDefinitionVersionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateDeviceDefinitionVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.deviceDefinitionId) { "deviceDefinitionId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("greengrass"))
                add(PercentEncoding.Path.encode("definition"))
                add(PercentEncoding.Path.encode("devices"))
                add(PercentEncoding.SmithyLabel.encode(input.deviceDefinitionId))
                add(PercentEncoding.Path.encode("versions"))
            }
        }

        builder.headers {
            if (input.amznClientToken != null) append("X-Amzn-Client-Token", input.amznClientToken)
        }

        val payload = serializeCreateDeviceDefinitionVersionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDeviceDefinitionVersionOperationBody(context: ExecutionContext, input: CreateDeviceDefinitionVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEVICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Devices"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.devices != null) {
            listField(DEVICES_DESCRIPTOR) {
                for (el0 in input.devices) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDeviceDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
