// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartBulkDeploymentRequest private constructor(builder: Builder) {
    /**
     * A client token used to correlate requests and responses.
     */
    public val amznClientToken: kotlin.String? = builder.amznClientToken
    /**
     * The ARN of the execution role to associate with the bulk deployment operation. This IAM role must allow the ''greengrass:CreateDeployment'' action for all group versions that are listed in the input file. This IAM role must have access to the S3 bucket containing the input file.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The URI of the input file contained in the S3 bucket. The execution role must have ''getObject'' permissions on this bucket to access the input file. The input file is a JSON-serialized, line delimited file with UTF-8 encoding that provides a list of group and version IDs and the deployment type. This file must be less than 100 MB. Currently, AWS IoT Greengrass supports only ''NewDeployment'' deployment types.
     */
    public val inputFileUri: kotlin.String? = builder.inputFileUri
    /**
     * Tag(s) to add to the new resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrass.model.StartBulkDeploymentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartBulkDeploymentRequest(")
        append("amznClientToken=$amznClientToken,")
        append("executionRoleArn=$executionRoleArn,")
        append("inputFileUri=$inputFileUri,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amznClientToken?.hashCode() ?: 0
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (inputFileUri?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartBulkDeploymentRequest

        if (amznClientToken != other.amznClientToken) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (inputFileUri != other.inputFileUri) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrass.model.StartBulkDeploymentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A client token used to correlate requests and responses.
         */
        public var amznClientToken: kotlin.String? = null
        /**
         * The ARN of the execution role to associate with the bulk deployment operation. This IAM role must allow the ''greengrass:CreateDeployment'' action for all group versions that are listed in the input file. This IAM role must have access to the S3 bucket containing the input file.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The URI of the input file contained in the S3 bucket. The execution role must have ''getObject'' permissions on this bucket to access the input file. The input file is a JSON-serialized, line delimited file with UTF-8 encoding that provides a list of group and version IDs and the deployment type. This file must be less than 100 MB. Currently, AWS IoT Greengrass supports only ''NewDeployment'' deployment types.
         */
        public var inputFileUri: kotlin.String? = null
        /**
         * Tag(s) to add to the new resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrass.model.StartBulkDeploymentRequest) : this() {
            this.amznClientToken = x.amznClientToken
            this.executionRoleArn = x.executionRoleArn
            this.inputFileUri = x.inputFileUri
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrass.model.StartBulkDeploymentRequest = StartBulkDeploymentRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
