// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Attributes that define a secret resource, which references a secret from AWS Secrets Manager. AWS IoT Greengrass stores a local, encrypted copy of the secret on the Greengrass core, where it can be securely accessed by connectors and Lambda functions.
 */
public class SecretsManagerSecretResourceData private constructor(builder: Builder) {
    /**
     * Optional. The staging labels whose values you want to make available on the core, in addition to ''AWSCURRENT''.
     */
    public val additionalStagingLabelsToDownload: List<String>? = builder.additionalStagingLabelsToDownload
    /**
     * The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest version (represented by the ''AWSCURRENT'' staging label) is included by default.
     */
    public val arn: kotlin.String? = builder.arn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrass.model.SecretsManagerSecretResourceData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecretsManagerSecretResourceData(")
        append("additionalStagingLabelsToDownload=$additionalStagingLabelsToDownload,")
        append("arn=$arn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalStagingLabelsToDownload?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecretsManagerSecretResourceData

        if (additionalStagingLabelsToDownload != other.additionalStagingLabelsToDownload) return false
        if (arn != other.arn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrass.model.SecretsManagerSecretResourceData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Optional. The staging labels whose values you want to make available on the core, in addition to ''AWSCURRENT''.
         */
        public var additionalStagingLabelsToDownload: List<String>? = null
        /**
         * The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest version (represented by the ''AWSCURRENT'' staging label) is included by default.
         */
        public var arn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrass.model.SecretsManagerSecretResourceData) : this() {
            this.additionalStagingLabelsToDownload = x.additionalStagingLabelsToDownload
            this.arn = x.arn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrass.model.SecretsManagerSecretResourceData = SecretsManagerSecretResourceData(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
