// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A container for resource data. The container takes only one of the following supported resource data types: ''LocalDeviceResourceData'', ''LocalVolumeResourceData'', ''SageMakerMachineLearningModelResourceData'', ''S3MachineLearningModelResourceData'', ''SecretsManagerSecretResourceData''.
 */
public class ResourceDataContainer private constructor(builder: Builder) {
    /**
     * Attributes that define the local device resource.
     */
    public val localDeviceResourceData: aws.sdk.kotlin.services.greengrass.model.LocalDeviceResourceData? = builder.localDeviceResourceData
    /**
     * Attributes that define the local volume resource.
     */
    public val localVolumeResourceData: aws.sdk.kotlin.services.greengrass.model.LocalVolumeResourceData? = builder.localVolumeResourceData
    /**
     * Attributes that define an Amazon S3 machine learning resource.
     */
    public val s3MachineLearningModelResourceData: aws.sdk.kotlin.services.greengrass.model.S3MachineLearningModelResourceData? = builder.s3MachineLearningModelResourceData
    /**
     * Attributes that define an Amazon SageMaker machine learning resource.
     */
    public val sageMakerMachineLearningModelResourceData: aws.sdk.kotlin.services.greengrass.model.SageMakerMachineLearningModelResourceData? = builder.sageMakerMachineLearningModelResourceData
    /**
     * Attributes that define a secret resource, which references a secret from AWS Secrets Manager.
     */
    public val secretsManagerSecretResourceData: aws.sdk.kotlin.services.greengrass.model.SecretsManagerSecretResourceData? = builder.secretsManagerSecretResourceData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrass.model.ResourceDataContainer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceDataContainer(")
        append("localDeviceResourceData=$localDeviceResourceData,")
        append("localVolumeResourceData=$localVolumeResourceData,")
        append("s3MachineLearningModelResourceData=$s3MachineLearningModelResourceData,")
        append("sageMakerMachineLearningModelResourceData=$sageMakerMachineLearningModelResourceData,")
        append("secretsManagerSecretResourceData=$secretsManagerSecretResourceData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = localDeviceResourceData?.hashCode() ?: 0
        result = 31 * result + (localVolumeResourceData?.hashCode() ?: 0)
        result = 31 * result + (s3MachineLearningModelResourceData?.hashCode() ?: 0)
        result = 31 * result + (sageMakerMachineLearningModelResourceData?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerSecretResourceData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceDataContainer

        if (localDeviceResourceData != other.localDeviceResourceData) return false
        if (localVolumeResourceData != other.localVolumeResourceData) return false
        if (s3MachineLearningModelResourceData != other.s3MachineLearningModelResourceData) return false
        if (sageMakerMachineLearningModelResourceData != other.sageMakerMachineLearningModelResourceData) return false
        if (secretsManagerSecretResourceData != other.secretsManagerSecretResourceData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrass.model.ResourceDataContainer = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Attributes that define the local device resource.
         */
        public var localDeviceResourceData: aws.sdk.kotlin.services.greengrass.model.LocalDeviceResourceData? = null
        /**
         * Attributes that define the local volume resource.
         */
        public var localVolumeResourceData: aws.sdk.kotlin.services.greengrass.model.LocalVolumeResourceData? = null
        /**
         * Attributes that define an Amazon S3 machine learning resource.
         */
        public var s3MachineLearningModelResourceData: aws.sdk.kotlin.services.greengrass.model.S3MachineLearningModelResourceData? = null
        /**
         * Attributes that define an Amazon SageMaker machine learning resource.
         */
        public var sageMakerMachineLearningModelResourceData: aws.sdk.kotlin.services.greengrass.model.SageMakerMachineLearningModelResourceData? = null
        /**
         * Attributes that define a secret resource, which references a secret from AWS Secrets Manager.
         */
        public var secretsManagerSecretResourceData: aws.sdk.kotlin.services.greengrass.model.SecretsManagerSecretResourceData? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrass.model.ResourceDataContainer) : this() {
            this.localDeviceResourceData = x.localDeviceResourceData
            this.localVolumeResourceData = x.localVolumeResourceData
            this.s3MachineLearningModelResourceData = x.s3MachineLearningModelResourceData
            this.sageMakerMachineLearningModelResourceData = x.sageMakerMachineLearningModelResourceData
            this.secretsManagerSecretResourceData = x.secretsManagerSecretResourceData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrass.model.ResourceDataContainer = ResourceDataContainer(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrass.model.LocalDeviceResourceData] inside the given [block]
         */
        public fun localDeviceResourceData(block: aws.sdk.kotlin.services.greengrass.model.LocalDeviceResourceData.Builder.() -> kotlin.Unit) {
            this.localDeviceResourceData = aws.sdk.kotlin.services.greengrass.model.LocalDeviceResourceData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.greengrass.model.LocalVolumeResourceData] inside the given [block]
         */
        public fun localVolumeResourceData(block: aws.sdk.kotlin.services.greengrass.model.LocalVolumeResourceData.Builder.() -> kotlin.Unit) {
            this.localVolumeResourceData = aws.sdk.kotlin.services.greengrass.model.LocalVolumeResourceData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.greengrass.model.S3MachineLearningModelResourceData] inside the given [block]
         */
        public fun s3MachineLearningModelResourceData(block: aws.sdk.kotlin.services.greengrass.model.S3MachineLearningModelResourceData.Builder.() -> kotlin.Unit) {
            this.s3MachineLearningModelResourceData = aws.sdk.kotlin.services.greengrass.model.S3MachineLearningModelResourceData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.greengrass.model.SageMakerMachineLearningModelResourceData] inside the given [block]
         */
        public fun sageMakerMachineLearningModelResourceData(block: aws.sdk.kotlin.services.greengrass.model.SageMakerMachineLearningModelResourceData.Builder.() -> kotlin.Unit) {
            this.sageMakerMachineLearningModelResourceData = aws.sdk.kotlin.services.greengrass.model.SageMakerMachineLearningModelResourceData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.greengrass.model.SecretsManagerSecretResourceData] inside the given [block]
         */
        public fun secretsManagerSecretResourceData(block: aws.sdk.kotlin.services.greengrass.model.SecretsManagerSecretResourceData.Builder.() -> kotlin.Unit) {
            this.secretsManagerSecretResourceData = aws.sdk.kotlin.services.greengrass.model.SecretsManagerSecretResourceData.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
