// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of the Lambda function.
 */
public class FunctionConfiguration private constructor(builder: Builder) {
    /**
     * The expected encoding type of the input payload for the function. The default is ''json''.
     */
    public val encodingType: aws.sdk.kotlin.services.greengrass.model.EncodingType? = builder.encodingType
    /**
     * The environment configuration of the function.
     */
    public val environment: aws.sdk.kotlin.services.greengrass.model.FunctionConfigurationEnvironment? = builder.environment
    /**
     * The execution arguments.
     */
    public val execArgs: kotlin.String? = builder.execArgs
    /**
     * The name of the function executable.
     */
    public val executable: kotlin.String? = builder.executable
    /**
     * The Lambda runtime supported by Greengrass which is to be used instead of the one specified in the Lambda function.
     */
    public val functionRuntimeOverride: kotlin.String? = builder.functionRuntimeOverride
    /**
     * The memory size, in KB, which the function requires. This setting is not applicable and should be cleared when you run the Lambda function without containerization.
     */
    public val memorySize: kotlin.Int? = builder.memorySize
    /**
     * True if the function is pinned. Pinned means the function is long-lived and starts when the core starts.
     */
    public val pinned: kotlin.Boolean? = builder.pinned
    /**
     * The allowed function execution time, after which Lambda should terminate the function. This timeout still applies to pinned Lambda functions for each request.
     */
    public val timeout: kotlin.Int? = builder.timeout

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrass.model.FunctionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionConfiguration(")
        append("encodingType=$encodingType,")
        append("environment=$environment,")
        append("execArgs=$execArgs,")
        append("executable=$executable,")
        append("functionRuntimeOverride=$functionRuntimeOverride,")
        append("memorySize=$memorySize,")
        append("pinned=$pinned,")
        append("timeout=$timeout")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encodingType?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (execArgs?.hashCode() ?: 0)
        result = 31 * result + (executable?.hashCode() ?: 0)
        result = 31 * result + (functionRuntimeOverride?.hashCode() ?: 0)
        result = 31 * result + (memorySize ?: 0)
        result = 31 * result + (pinned?.hashCode() ?: 0)
        result = 31 * result + (timeout ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FunctionConfiguration

        if (encodingType != other.encodingType) return false
        if (environment != other.environment) return false
        if (execArgs != other.execArgs) return false
        if (executable != other.executable) return false
        if (functionRuntimeOverride != other.functionRuntimeOverride) return false
        if (memorySize != other.memorySize) return false
        if (pinned != other.pinned) return false
        if (timeout != other.timeout) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrass.model.FunctionConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The expected encoding type of the input payload for the function. The default is ''json''.
         */
        public var encodingType: aws.sdk.kotlin.services.greengrass.model.EncodingType? = null
        /**
         * The environment configuration of the function.
         */
        public var environment: aws.sdk.kotlin.services.greengrass.model.FunctionConfigurationEnvironment? = null
        /**
         * The execution arguments.
         */
        public var execArgs: kotlin.String? = null
        /**
         * The name of the function executable.
         */
        public var executable: kotlin.String? = null
        /**
         * The Lambda runtime supported by Greengrass which is to be used instead of the one specified in the Lambda function.
         */
        public var functionRuntimeOverride: kotlin.String? = null
        /**
         * The memory size, in KB, which the function requires. This setting is not applicable and should be cleared when you run the Lambda function without containerization.
         */
        public var memorySize: kotlin.Int? = null
        /**
         * True if the function is pinned. Pinned means the function is long-lived and starts when the core starts.
         */
        public var pinned: kotlin.Boolean? = null
        /**
         * The allowed function execution time, after which Lambda should terminate the function. This timeout still applies to pinned Lambda functions for each request.
         */
        public var timeout: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrass.model.FunctionConfiguration) : this() {
            this.encodingType = x.encodingType
            this.environment = x.environment
            this.execArgs = x.execArgs
            this.executable = x.executable
            this.functionRuntimeOverride = x.functionRuntimeOverride
            this.memorySize = x.memorySize
            this.pinned = x.pinned
            this.timeout = x.timeout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrass.model.FunctionConfiguration = FunctionConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrass.model.FunctionConfigurationEnvironment] inside the given [block]
         */
        public fun environment(block: aws.sdk.kotlin.services.greengrass.model.FunctionConfigurationEnvironment.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.greengrass.model.FunctionConfigurationEnvironment.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
