// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.serde

import aws.sdk.kotlin.services.greengrass.model.GreengrassException
import aws.sdk.kotlin.services.greengrass.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UntagResourceOperationDeserializer: HttpDeserializer.NonStreaming<UntagResourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UntagResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUntagResourceError(context, call, payload)
        }
        val builder = UntagResourceResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUntagResourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GreengrassException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GreengrassException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
