// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.serde

import aws.sdk.kotlin.services.greengrass.model.DeploymentType
import aws.sdk.kotlin.services.greengrass.model.ErrorDetail
import aws.sdk.kotlin.services.greengrass.model.GetDeploymentStatusResponse
import aws.sdk.kotlin.services.greengrass.model.GreengrassException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetDeploymentStatusOperationDeserializer: HttpDeserializer.NonStreaming<GetDeploymentStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetDeploymentStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDeploymentStatusError(context, call, payload)
        }
        val builder = GetDeploymentStatusResponse.Builder()

        if (payload != null) {
            deserializeGetDeploymentStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetDeploymentStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GreengrassException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GreengrassException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDeploymentStatusOperationBody(builder: GetDeploymentStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEPLOYMENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeploymentStatus"))
    val DEPLOYMENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DeploymentType"))
    val ERRORDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ErrorDetails"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UpdatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENTSTATUS_DESCRIPTOR)
        field(DEPLOYMENTTYPE_DESCRIPTOR)
        field(ERRORDETAILS_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPLOYMENTSTATUS_DESCRIPTOR.index -> builder.deploymentStatus = deserializeString()
                DEPLOYMENTTYPE_DESCRIPTOR.index -> builder.deploymentType = deserializeString().let { DeploymentType.fromValue(it) }
                ERRORDETAILS_DESCRIPTOR.index -> builder.errorDetails =
                    deserializer.deserializeList(ERRORDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<ErrorDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeErrorDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
