// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.serde

import aws.sdk.kotlin.services.greengrass.model.BulkDeploymentMetrics
import aws.sdk.kotlin.services.greengrass.model.BulkDeploymentStatus
import aws.sdk.kotlin.services.greengrass.model.ErrorDetail
import aws.sdk.kotlin.services.greengrass.model.GetBulkDeploymentStatusResponse
import aws.sdk.kotlin.services.greengrass.model.GreengrassException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetBulkDeploymentStatusOperationDeserializer: HttpDeserializer.NonStreaming<GetBulkDeploymentStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetBulkDeploymentStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBulkDeploymentStatusError(context, call, payload)
        }
        val builder = GetBulkDeploymentStatusResponse.Builder()

        if (payload != null) {
            deserializeGetBulkDeploymentStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetBulkDeploymentStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GreengrassException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GreengrassException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBulkDeploymentStatusOperationBody(builder: GetBulkDeploymentStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BULKDEPLOYMENTMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BulkDeploymentMetrics"))
    val BULKDEPLOYMENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("BulkDeploymentStatus"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatedAt"))
    val ERRORDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ErrorDetails"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BULKDEPLOYMENTMETRICS_DESCRIPTOR)
        field(BULKDEPLOYMENTSTATUS_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(ERRORDETAILS_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BULKDEPLOYMENTMETRICS_DESCRIPTOR.index -> builder.bulkDeploymentMetrics = deserializeBulkDeploymentMetricsDocument(deserializer)
                BULKDEPLOYMENTSTATUS_DESCRIPTOR.index -> builder.bulkDeploymentStatus = deserializeString().let { BulkDeploymentStatus.fromValue(it) }
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString()
                ERRORDETAILS_DESCRIPTOR.index -> builder.errorDetails =
                    deserializer.deserializeList(ERRORDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<ErrorDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeErrorDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
