// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.serde

import aws.sdk.kotlin.services.greengrass.model.CreateResourceDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.Resource
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateResourceDefinitionVersionOperationSerializer: HttpSerializer.NonStreaming<CreateResourceDefinitionVersionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateResourceDefinitionVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.resourceDefinitionId) { "resourceDefinitionId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("greengrass"))
                add(PercentEncoding.Path.encode("definition"))
                add(PercentEncoding.Path.encode("resources"))
                add(PercentEncoding.SmithyLabel.encode(input.resourceDefinitionId))
                add(PercentEncoding.Path.encode("versions"))
            }
        }

        builder.headers {
            if (input.amznClientToken != null) append("X-Amzn-Client-Token", input.amznClientToken)
        }

        val payload = serializeCreateResourceDefinitionVersionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateResourceDefinitionVersionOperationBody(context: ExecutionContext, input: CreateResourceDefinitionVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val RESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Resources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESOURCES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.resources != null) {
            listField(RESOURCES_DESCRIPTOR) {
                for (el0 in input.resources) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeResourceDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
