// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.serde

import aws.sdk.kotlin.services.greengrass.model.CreateGroupVersionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateGroupVersionOperationSerializer: HttpSerializer.NonStreaming<CreateGroupVersionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateGroupVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.groupId) { "groupId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("greengrass"))
                add(PercentEncoding.Path.encode("groups"))
                add(PercentEncoding.SmithyLabel.encode(input.groupId))
                add(PercentEncoding.Path.encode("versions"))
            }
        }

        builder.headers {
            if (input.amznClientToken != null) append("X-Amzn-Client-Token", input.amznClientToken)
        }

        val payload = serializeCreateGroupVersionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateGroupVersionOperationBody(context: ExecutionContext, input: CreateGroupVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONNECTORDEFINITIONVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectorDefinitionVersionArn"))
    val COREDEFINITIONVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CoreDefinitionVersionArn"))
    val DEVICEDEFINITIONVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceDefinitionVersionArn"))
    val FUNCTIONDEFINITIONVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FunctionDefinitionVersionArn"))
    val LOGGERDEFINITIONVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LoggerDefinitionVersionArn"))
    val RESOURCEDEFINITIONVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceDefinitionVersionArn"))
    val SUBSCRIPTIONDEFINITIONVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubscriptionDefinitionVersionArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTORDEFINITIONVERSIONARN_DESCRIPTOR)
        field(COREDEFINITIONVERSIONARN_DESCRIPTOR)
        field(DEVICEDEFINITIONVERSIONARN_DESCRIPTOR)
        field(FUNCTIONDEFINITIONVERSIONARN_DESCRIPTOR)
        field(LOGGERDEFINITIONVERSIONARN_DESCRIPTOR)
        field(RESOURCEDEFINITIONVERSIONARN_DESCRIPTOR)
        field(SUBSCRIPTIONDEFINITIONVERSIONARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.connectorDefinitionVersionArn?.let { field(CONNECTORDEFINITIONVERSIONARN_DESCRIPTOR, it) }
        input.coreDefinitionVersionArn?.let { field(COREDEFINITIONVERSIONARN_DESCRIPTOR, it) }
        input.deviceDefinitionVersionArn?.let { field(DEVICEDEFINITIONVERSIONARN_DESCRIPTOR, it) }
        input.functionDefinitionVersionArn?.let { field(FUNCTIONDEFINITIONVERSIONARN_DESCRIPTOR, it) }
        input.loggerDefinitionVersionArn?.let { field(LOGGERDEFINITIONVERSIONARN_DESCRIPTOR, it) }
        input.resourceDefinitionVersionArn?.let { field(RESOURCEDEFINITIONVERSIONARN_DESCRIPTOR, it) }
        input.subscriptionDefinitionVersionArn?.let { field(SUBSCRIPTIONDEFINITIONVERSIONARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
